/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.ws.ext.restlet.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.logging.Level;
import org.orioai.ws.ext.beans.WSOperationBean;
import org.orioai.ws.ext.xstream.converter.WSOperationConverter;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

public class WSOperationBeanRepresentation<T>
extends OutputRepresentation {
    private T object;
    private Representation representation;
    private Class<? extends HierarchicalStreamDriver> jsonDriverClass;
    private Class<? extends HierarchicalStreamDriver> xmlDriverClass;
    private XStream xstream;

    public WSOperationBeanRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.representation = null;
        this.jsonDriverClass = JettisonMappedXmlDriver.class;
        this.xmlDriverClass = StaxDriver.class;
        this.xstream = null;
    }

    public WSOperationBeanRepresentation(Representation source) {
        super(source.getMediaType());
        this.object = null;
        this.representation = source;
        this.jsonDriverClass = JettisonMappedXmlDriver.class;
        this.xmlDriverClass = StaxDriver.class;
        this.xstream = null;
    }

    protected XStream createXstream(MediaType mediaType) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.registerConverter((Converter)new WSOperationConverter());
        return xstream;
    }

    public T getObject() {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.representation != null) {
            try {
                result = this.getXstream().fromXML(this.inputStreamAsString(this.representation.getStream()));
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the object with XStream.", e);
            }
        }
        return (T)result;
    }

    public Class<? extends HierarchicalStreamDriver> getJsonDriverClass() {
        return this.jsonDriverClass;
    }

    public Class<? extends HierarchicalStreamDriver> getXmlDriverClass() {
        return this.xmlDriverClass;
    }

    public XStream getXstream() {
        if (this.xstream == null) {
            this.xstream = this.createXstream(this.getMediaType());
        }
        this.xstream.processAnnotations(WSOperationBean.class);
        return this.xstream;
    }

    public void setJsonDriverClass(Class<? extends HierarchicalStreamDriver> jsonDriverClass) {
        this.jsonDriverClass = jsonDriverClass;
    }

    public void setXmlDriverClass(Class<? extends HierarchicalStreamDriver> xmlDriverClass) {
        this.xmlDriverClass = xmlDriverClass;
    }

    public void setXstream(XStream xstream) {
        this.xstream = xstream;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.representation != null) {
            this.representation.write(outputStream);
        } else if (this.object != null) {
            this.getXstream().toXML(this.object, outputStream);
        }
    }

    private String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }
}

