/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.indexing.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneQueryGenerator {
    protected static Logger log = LoggerFactory.getLogger(LuceneQueryGenerator.class);
    public static final String OR = "OR";
    public static final String AND = "AND";
    protected static final String idMetadataName = "md-ori-oai-id";
    protected static final String LUCENE_ESCAPE_CHARS_FOR_IDENTIFIER = "[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?]";
    protected static final String LUCENE_ESCAPE_CHARS_FOR_VALUES = "[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\/]";
    protected static final Pattern LUCENE_PATTERN_FOR_IDENTIFIER = Pattern.compile("[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\*\\?]");
    protected static final Pattern LUCENE_PATTERN_FOR_VALUES = Pattern.compile("[\\\\+\\-\\!\\(\\)\\:\\^\\]\\{\\}\\~\\/]");
    protected static final String REPLACEMENT_STRING = "\\\\$0";

    public String addParenthesis(String request) {
        if (request == null || "".equals(request.trim())) {
            return null;
        }
        if (!request.trim().startsWith("NOT") && !request.equals("*")) {
            return "(" + request + ")";
        }
        return request;
    }

    public String getValuesAssociation(List<String> elements, String operator, boolean quoteIfNeeded) {
        return this.getValuesAssociation(elements, operator, quoteIfNeeded, true);
    }

    public String getValuesAssociation(List<String> elements, String operator, boolean quoteIfNeeded, boolean parenthesis) {
        String element;
        int i;
        if (elements == null || elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return this.addQuoteIfNeeded(elements.get(0), quoteIfNeeded);
        }
        String s = "";
        ArrayList<String> notEmptyelements = new ArrayList<String>();
        for (i = 0; i < elements.size(); ++i) {
            element = elements.get(i);
            if (element == null || "".equals(element.trim())) continue;
            notEmptyelements.add(element);
        }
        for (i = 0; i < notEmptyelements.size(); ++i) {
            element = (String)notEmptyelements.get(i);
            if (notEmptyelements.indexOf(element) != i) continue;
            if (i > 0) {
                s = s + " " + operator + " ";
            }
            s = s + this.addQuoteIfNeeded(element, quoteIfNeeded);
        }
        if (parenthesis) {
            s = this.addParenthesis(s);
        }
        return s;
    }

    public String getAssociation(List<String> elements, String operator, boolean parenthesis) {
        return this.getValuesAssociation(elements, operator, false, parenthesis);
    }

    public String getAssociation(List<String> elements, String operator) {
        return this.getValuesAssociation(elements, operator, false, true);
    }

    public String getAndAssociation(List<String> elements) {
        return this.getAssociation(elements, AND);
    }

    public String addQuoteIfNeeded(String value, boolean quoteIfNeeded) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        if (quoteIfNeeded) {
            if (value.indexOf("\"") != -1) {
                return value;
            }
            if (value.indexOf("*") != -1) {
                return value.replaceAll(" ", "\\\\ ");
            }
            return "\"" + value + "\"";
        }
        return value;
    }

    public String getDateValueRequest(String fromDate, String toDate) {
        if (fromDate == null || toDate == null) {
            return null;
        }
        return this.addParenthesis("[\"" + fromDate + "\" TO \"" + toDate + "\"]");
    }

    public String getSimpleValueRequest(String value) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        return this.addParenthesis(this.escapeValue(value));
    }

    public String escapeValue(String value) {
        return LUCENE_PATTERN_FOR_VALUES.matcher(value).replaceAll(REPLACEMENT_STRING);
    }

    public String getNotRequest(String request) {
        if (request == null || "".equals(request.trim())) {
            return null;
        }
        return "NOT " + request;
    }

    public String getValueAssociation(String metadata, String value, boolean quoteIfNeeded) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        String result = null;
        result = value.endsWith(")") && value.startsWith("(") ? metadata + ":" + this.addQuoteIfNeeded(value, quoteIfNeeded) : metadata + ":" + this.addParenthesis(this.addQuoteIfNeeded(value, quoteIfNeeded));
        return result;
    }

    public String getAssociation(String metadata, String value) {
        return this.getValueAssociation(metadata, value, false);
    }

    public String getDefaultAllDocumentsRequest() {
        return "*:*";
    }

    public String addBoost(String value, Float boost) {
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        String result = value;
        if (boost != null) {
            if (!value.startsWith("(") || !value.endsWith(")")) {
                result = this.addParenthesis(result);
            }
            result = result + "^" + boost;
        }
        return result;
    }

    public String getLanguageRequest(String language, Map<String, String> langSearchMap, boolean exclusiveLanguage, String metadataName, List<Float> langSearchBoostList, String fieldRequestValue) {
        String metadataRequest = "";
        log.debug("language = {}", (Object)language);
        String suffixCurrent = langSearchMap.get(language);
        if (exclusiveLanguage) {
            if (suffixCurrent != null) {
                metadataRequest = this.getAssociation(metadataName + suffixCurrent, fieldRequestValue);
                log.debug("metadataRequest (exclusiveLanguage) = {}", (Object)metadataRequest);
            } else {
                log.error("language " + language + " not found");
            }
        } else {
            ArrayList<String> fieldLangRequestElements = new ArrayList<String>();
            if (suffixCurrent != null) {
                String langRequest = this.getAssociation(metadataName + suffixCurrent, fieldRequestValue);
                langRequest = this.addBoost(langRequest, langSearchBoostList.get(0));
                log.debug("langRequest suffix = {}", (Object)langRequest);
                fieldLangRequestElements.add(langRequest);
            } else {
                log.error("language " + language + " not found");
            }
            int l = 1;
            for (String langKey : langSearchMap.keySet()) {
                if (langKey.equals(language)) continue;
                String suffix = langSearchMap.get(langKey);
                String langRequest = this.getAssociation(metadataName + suffix, fieldRequestValue);
                langRequest = this.addBoost(langRequest, langSearchBoostList.get(l));
                log.debug("langRequest = {}", (Object)langRequest);
                fieldLangRequestElements.add(langRequest);
                ++l;
            }
            metadataRequest = this.getAssociation(fieldLangRequestElements, OR);
        }
        return metadataRequest;
    }

    public String getRequest(String metadata, String value) {
        String metadataName = metadata;
        return this.getValueAssociation(metadataName, value, true);
    }

    public String getNoticeRequest(String idValue) {
        String escapedIdValue = LUCENE_PATTERN_FOR_IDENTIFIER.matcher(idValue).replaceAll(REPLACEMENT_STRING);
        escapedIdValue = escapedIdValue.replaceAll("\u2019", "%E2%80%99");
        escapedIdValue = escapedIdValue.replaceAll("\u00ab", "%C2%AB");
        escapedIdValue = escapedIdValue.replaceAll("\u00bb", "%C2%BB");
        escapedIdValue = escapedIdValue.replaceAll(" ", "%20");
        String idAssociation = this.getValueAssociation(idMetadataName, escapedIdValue, true);
        String request = this.addParenthesis(idAssociation);
        log.debug("request={}", (Object)request);
        return request;
    }
}

