/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service.remote;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTermLabel;

public class RemoteVocabularyTermCaption {
    private static final String DEFAULT_LANGUAGE = "default";
    private Hashtable<String, RemoteVocabularyTermLabel> labels = new Hashtable();

    public Hashtable<String, RemoteVocabularyTermLabel> getLabels() {
        return this.labels;
    }

    public String getLabel(String language, String defaultLanguage) {
        Iterator<RemoteVocabularyTermLabel> iter;
        Collection<RemoteVocabularyTermLabel> collec;
        if (language == null && defaultLanguage == null) {
            return null;
        }
        RemoteVocabularyTermLabel vcl = this.labels.get(language);
        if (vcl == null) {
            vcl = this.labels.get(defaultLanguage);
        }
        if (vcl == null) {
            vcl = this.labels.get(DEFAULT_LANGUAGE);
        }
        if (vcl == null && (collec = this.labels.values()) != null && (iter = collec.iterator()) != null && iter.hasNext()) {
            vcl = iter.next();
        }
        if (vcl == null) {
            return null;
        }
        return vcl.getValue();
    }

    public void addLabel(RemoteVocabularyTermLabel label) {
        String lang = label.getLanguage();
        if (lang == null) {
            this.labels.put(DEFAULT_LANGUAGE, label);
        } else {
            this.labels.put(lang, label);
        }
    }

    public void setLabels(Hashtable<String, RemoteVocabularyTermLabel> labels) {
        this.labels = labels;
    }

    public String toString() {
        return this.labels.toString();
    }
}

