/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.orioai.commons.vcard.IVcardService;
import org.orioai.commons.vocabulary.Term;
import org.orioai.commons.vocabulary.TermValue;
import org.orioai.commons.vocabulary.service.CreateVocabulary;
import org.orioai.commons.vocabulary.service.IVocabularyService;
import org.orioai.commons.vocabulary.service.exceptions.NotFoundVocabularyTermException;
import org.orioai.commons.vocabulary.service.remote.RemoteVocabularyTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VocabularyServiceImpl
implements IVocabularyService {
    private static Logger log = LoggerFactory.getLogger(VocabularyServiceImpl.class);
    private String oriOaiVocabularyServiceUrl;
    protected IVcardService vcardService;
    protected Cache termVocabularyCache;
    protected Cache termVocabularyLastKnownCache;
    protected HashMap<String, List<String>> vocabulariesVcardAttributes = new HashMap();
    protected Cache xmlVocabularyCache;
    protected Cache xmlVocabularyLastKnownCache;

    public void setTermVocabularyCache(Cache termVocabularyCache) {
        this.termVocabularyCache = termVocabularyCache;
    }

    public void setTermVocabularyLastKnownCache(Cache termVocabularyLastKnownCache) {
        this.termVocabularyLastKnownCache = termVocabularyLastKnownCache;
    }

    public void setXmlVocabularyCache(Cache xmlVocabularyCache) {
        this.xmlVocabularyCache = xmlVocabularyCache;
    }

    public void setXmlVocabularyLastKnownCache(Cache xmlVocabularyLastKnownCache) {
        this.xmlVocabularyLastKnownCache = xmlVocabularyLastKnownCache;
    }

    public void setOriOaiVocabularyServiceUrl(String oriOaiVocabularyServiceUrl) {
        this.oriOaiVocabularyServiceUrl = oriOaiVocabularyServiceUrl;
    }

    public void setVcardService(IVcardService vcardService) {
        this.vcardService = vcardService;
    }

    protected static Term getTermFromVocabulary(RemoteVocabularyTerm rootTerm, List<String> allLanguages, String defaultLanguage) {
        return VocabularyServiceImpl.getTermFromVocabulary(rootTerm, allLanguages, defaultLanguage, 0);
    }

    protected static Term getTermFromVocabulary(RemoteVocabularyTerm rootTerm, List<String> allLanguages, String defaultLanguage, int level) {
        Term cat = new Term();
        cat.setLevel(level);
        cat.setId(rootTerm.getId());
        cat.setLabels(rootTerm.getLabels(allLanguages, defaultLanguage));
        cat.setDescriptions(rootTerm.getDescriptions(allLanguages, defaultLanguage));
        List<String> values = rootTerm.getValues();
        for (int i = 0; values != null && i < values.size(); ++i) {
            TermValue cv = new TermValue();
            cv.setValue(values.get(i));
            cat.setValue(cv);
        }
        List<RemoteVocabularyTerm> children = rootTerm.getChildren();
        for (int i = 0; children != null && i < children.size(); ++i) {
            RemoteVocabularyTerm child = children.get(i);
            cat.setTerm(VocabularyServiceImpl.getTermFromVocabulary(child, allLanguages, defaultLanguage, level + 1));
        }
        return cat;
    }

    private Term getRootVocabularyTerm(String vocabularyId, List<String> availableLanguages, String defaultLanguage) {
        return this.getRootVocabularyTerm(vocabularyId, true, availableLanguages, defaultLanguage);
    }

    protected Term getRootVocabularyTerm(String vocabularyId, boolean waitResponse, List<String> availableLanguages, String defaultLanguage) {
        Term vtc = null;
        Element termVocabularyCacheElt = null;
        try {
            termVocabularyCacheElt = this.termVocabularyCache.get((Serializable)((Object)vocabularyId));
        }
        catch (IllegalStateException e) {
            log.warn("getRootVocabularyTerm :: vocabularyId=" + vocabularyId + " :: IllegalStateException", (Throwable)e);
        }
        if (termVocabularyCacheElt == null) {
            log.info("getRootVocabularyTerm :: the term into the cache is null, we are going to get the last known :: {} (waitResponse={})", (Object)vocabularyId, (Object)waitResponse);
            Element termVocabularyLastKnownCacheElt = null;
            try {
                termVocabularyLastKnownCacheElt = this.termVocabularyLastKnownCache.get((Serializable)((Object)vocabularyId));
                if (termVocabularyLastKnownCacheElt != null) {
                    vtc = (Term)termVocabularyLastKnownCacheElt.getObjectValue();
                }
            }
            catch (IllegalStateException e) {
                log.warn("getRootVocabularyTerm :: vocabularyId=" + vocabularyId + " :: IllegalStateException", (Throwable)e);
            }
            if (vtc == null) {
                log.debug("getRootVocabularyTerm :: {} :: last known getted is null", (Object)vocabularyId);
            } else {
                log.debug("getRootVocabularyTerm :: {} :: last known getted is NOT null", (Object)vocabularyId);
            }
            CreateVocabulary cv = new CreateVocabulary(vocabularyId, availableLanguages, defaultLanguage, vtc, this.xmlVocabularyCache, this.xmlVocabularyLastKnownCache, this.termVocabularyCache, this.termVocabularyLastKnownCache, this.oriOaiVocabularyServiceUrl, this.vocabulariesVcardAttributes, this.vcardService);
            cv.start();
            if (waitResponse && vtc == null) {
                int resultState = cv.resultState;
                while (waitResponse && vtc == null && (resultState == -1 || resultState == 2)) {
                    if (resultState == 2) {
                        cv = new CreateVocabulary(vocabularyId, availableLanguages, defaultLanguage, vtc, this.xmlVocabularyCache, this.xmlVocabularyLastKnownCache, this.termVocabularyCache, this.termVocabularyLastKnownCache, this.oriOaiVocabularyServiceUrl, this.vocabulariesVcardAttributes, this.vcardService);
                        cv.start();
                    }
                    try {
                        cv.join(60000L);
                    }
                    catch (InterruptedException e) {
                        log.error("getRootVocabularyTerm :: InterruptedException", (Throwable)e);
                    }
                    resultState = cv.resultState;
                    if (resultState == 1) {
                        termVocabularyCacheElt = this.termVocabularyCache.get((Serializable)((Object)vocabularyId));
                        if (termVocabularyCacheElt == null) continue;
                        vtc = (Term)termVocabularyCacheElt.getObjectValue();
                        continue;
                    }
                    if (resultState != 0) continue;
                    vtc = null;
                }
            }
        } else {
            vtc = (Term)termVocabularyCacheElt.getObjectValue();
            log.debug("getRootVocabularyTerm :: get the term from the cache :: {}", (Object)vocabularyId);
        }
        return vtc;
    }

    @Override
    public void initRootTerm(String vocabularyId, HashMap<String, List<String>> vocabulariesVcardAttributes, List<String> availableLanguages, String defaultLanguage) {
        this.vocabulariesVcardAttributes = vocabulariesVcardAttributes;
        if (this.vocabulariesVcardAttributes != null) {
            for (String key : this.vocabulariesVcardAttributes.keySet()) {
                List<String> attributes = this.vocabulariesVcardAttributes.get(key);
                if (!attributes.contains("N") || attributes.contains("ORG")) continue;
                attributes.add("ORG");
            }
        }
        this.getRootVocabularyTerm(vocabularyId, false, availableLanguages, defaultLanguage);
    }

    @Override
    public Term getRootTerm(String vocabularyId, List<String> availableLanguages, String defaultLanguage) {
        return this.getTerm(vocabularyId, null, availableLanguages, defaultLanguage);
    }

    @Override
    public Term getTerm(String vocabularyId, String id, List<String> availableLanguages, String defaultLanguage) {
        Term foundTerm = null;
        log.debug("getTerm :: Search term with vocabularyId={} ,id={}", (Object)vocabularyId, (Object)id);
        try {
            Term rootTerm = this.getRootVocabularyTerm(vocabularyId, availableLanguages, defaultLanguage);
            if (id == null || id.trim().equals("")) {
                foundTerm = rootTerm;
            } else {
                foundTerm = this.searchTerm(rootTerm, id);
                if (foundTerm == null) {
                    log.debug("getTerm :: Unable find term with vocabularyId={} ,id={}", (Object)vocabularyId, (Object)id);
                    throw new NotFoundVocabularyTermException();
                }
            }
        }
        catch (Exception e) {
            log.debug("getTerm :: Unable find term with vocabularyId={} ,id={}", (Object)new Object[]{vocabularyId, id}, (Object)e);
        }
        return foundTerm;
    }

    @Override
    public List<Term> getTermsHierarchy(String vocabularyId, String id, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<Term> terms = new ArrayList<Term>();
        Term last = this.getTerm(vocabularyId, id, availableLanguages, defaultLanguage);
        if (last != null) {
            terms.add(0, last);
            for (Term term = last.getParent(); term != null; term = term.getParent()) {
                terms.add(0, term);
            }
        }
        return terms;
    }

    private Term searchTerm(Term vocabularyTerm, String id) {
        if (vocabularyTerm != null) {
            String termId = vocabularyTerm.getId();
            if (termId != null && termId.equals(id)) {
                return vocabularyTerm;
            }
            List<Term> children = vocabularyTerm.getChildren();
            if (children == null || children.size() == 0) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                Term foundCat = this.searchTerm(children.get(i), id);
                if (foundCat == null) continue;
                return foundCat;
            }
            return null;
        }
        return null;
    }

    @Override
    public Hashtable<String, String> getVocabularyLabelsFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String language, String defaultLanguage) {
        ArrayList<String> vocabularyIds = new ArrayList<String>();
        vocabularyIds.add(vocabularyId);
        ArrayList<List<String>> allIds = new ArrayList<List<String>>();
        allIds.add(ids);
        return this.getVocabularyLabelsFromIds(vocabularyIds, allIds, availableLanguages, language, defaultLanguage);
    }

    @Override
    public Hashtable<String, String> getVocabularyLabelsFromIds(List<String> vocabularyIds, List<List<String>> allIds, List<String> availableLanguages, String language, String defaultLanguage) {
        Hashtable<String, String> labels = new Hashtable<String, String>();
        for (int i = 0; i < vocabularyIds.size(); ++i) {
            String vocabularyId = vocabularyIds.get(i);
            List<String> ids = allIds.get(i);
            for (int j = 0; j < ids.size(); ++j) {
                String id = ids.get(j);
                labels.put(vocabularyId + "_" + id, this.getTerm(vocabularyId, id, availableLanguages, defaultLanguage).getLabel(language, defaultLanguage));
            }
        }
        return labels;
    }

    @Override
    public List<TermValue> getVocabularyAllValuesFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<TermValue> allValues = new ArrayList<TermValue>();
        for (int i = 0; i < ids.size(); ++i) {
            Term term = this.getTerm(vocabularyId, ids.get(i), availableLanguages, defaultLanguage);
            List<TermValue> termValues = term.getAllHierarchyValues();
            for (int j = 0; j < termValues.size(); ++j) {
                allValues.add(termValues.get(j));
            }
        }
        return allValues;
    }

    @Override
    public List<String> getVocabularyAllSimpleValuesFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<String> allValues = new ArrayList<String>();
        for (int i = 0; i < ids.size(); ++i) {
            Term term = this.getTerm(vocabularyId, ids.get(i), availableLanguages, defaultLanguage);
            List<TermValue> termValues = term.getAllHierarchyValues();
            for (int j = 0; j < termValues.size(); ++j) {
                allValues.add(termValues.get(j).getValue());
            }
        }
        return allValues;
    }

    @Override
    public List<TermValue> getVocabularyNodeValuesFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<TermValue> values = new ArrayList<TermValue>();
        for (int i = 0; i < ids.size(); ++i) {
            log.debug("getVocabularyNodeValuesFromIds :: vocabularyId={}, ids.get({})={}", new Object[]{vocabularyId, i, ids.get(i)});
            Term term = this.getTerm(vocabularyId, ids.get(i), availableLanguages, defaultLanguage);
            if (term == null) {
                return null;
            }
            List<TermValue> termValues = term.getValues();
            for (int j = 0; j < termValues.size(); ++j) {
                values.add(termValues.get(j));
            }
        }
        return values;
    }

    @Override
    public List<TermValue> getVocabularyNodeValuesFromId(String vocabularyId, String id, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<String> ids = new ArrayList<String>(1);
        ids.add(id);
        return this.getVocabularyNodeValuesFromIds(vocabularyId, ids, availableLanguages, defaultLanguage);
    }

    @Override
    public Term getTermsFromValue(String vocabularyId, String value, String vcardAttribute, List<String> availableLanguages, String defaultLanguage) {
        Term foundTerm;
        Term result = null;
        Term root = this.getRootTerm(vocabularyId, availableLanguages, defaultLanguage);
        result = root != null ? (foundTerm = this.searchHierarchyOfValue(root, value, vcardAttribute)) : null;
        return result;
    }

    @Override
    public Term getTermsFromValue(String vocabularyId, String value, List<String> availableLanguages, String defaultLanguage) {
        return this.getTermsFromValue(vocabularyId, value, null, availableLanguages, defaultLanguage);
    }

    @Override
    public List<Term> getTermsLeafsFromValue(String vocabularyId, String value, String vcardAttribute, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<Term> termsLeafs = new ArrayList<Term>();
        Term t = this.getTermsFromValue(vocabularyId, value, vcardAttribute, availableLanguages, defaultLanguage);
        this.getTermsLeafs(t, termsLeafs);
        return termsLeafs;
    }

    private Term searchHierarchyOfValue(Term rootTerm, String value, String vcardAttribute) {
        TermValue localValue;
        int i;
        List<TermValue> allHierarchyValues = rootTerm.getAllHierarchyValues();
        TermValue foundValue = null;
        for (i = 0; foundValue == null && allHierarchyValues != null && i < allHierarchyValues.size(); ++i) {
            localValue = allHierarchyValues.get(i);
            if (!this.matches(value, vcardAttribute, localValue, false)) continue;
            foundValue = localValue;
        }
        for (i = 0; foundValue == null && allHierarchyValues != null && i < allHierarchyValues.size(); ++i) {
            localValue = allHierarchyValues.get(i);
            if (!this.matches(value, vcardAttribute, localValue, true)) continue;
            foundValue = localValue;
        }
        if (foundValue != null) {
            Term foundTermToReturn = this.searchHierarchyOfValue(foundValue);
            return foundTermToReturn;
        }
        return null;
    }

    private Term searchHierarchyOfValue(TermValue termValue) {
        Term foundTermPreviousChild = null;
        for (Term foundTerm = termValue.getTerm(); foundTerm != null; foundTerm = foundTerm.getParent()) {
            Term foundTermClone = foundTerm.cloneWithoutFamily();
            if (foundTermPreviousChild != null) {
                ArrayList<Term> children = new ArrayList<Term>(1);
                children.add(foundTermPreviousChild);
                foundTermClone.setChildren(children);
                foundTermPreviousChild.setParent(foundTermClone);
            }
            foundTermPreviousChild = foundTermClone;
        }
        Term foundTermToReturn = foundTermPreviousChild;
        return foundTermToReturn;
    }

    private static String getRegexpFromValue(String value) {
        String regexp = "";
        String lowerCaserTermValue = value.toLowerCase().trim();
        String[] elts = lowerCaserTermValue.split("\\*");
        for (int l = 0; l < elts.length; ++l) {
            String elt = elts[l];
            elt = elt.replaceAll("\\(", "\\\\(");
            elt = elt.replaceAll("\\)", "\\\\)");
            elt = elt.replaceAll("\\[", "\\\\[");
            elt = elt.replaceAll("\\]", "\\\\]");
            elt = elt.replaceAll("\\+", "\\\\+");
            elt = elt.replaceAll("\\?", "\\\\?");
            regexp = regexp + "(" + elt + ")";
            if (l == elts.length - 1 && !lowerCaserTermValue.endsWith("*")) continue;
            regexp = regexp + ".*";
        }
        return regexp;
    }

    private boolean matches(String value, String vcardAttribute, TermValue termValue, boolean switchNameToOrg) {
        if (value == null || termValue == null) {
            return false;
        }
        List<String> termValues = null;
        if (vcardAttribute != null) {
            termValues = termValue.getVcardAttributeValues(vcardAttribute);
            if (switchNameToOrg && vcardAttribute.equals("N") && (termValues == null || termValues.isEmpty() || termValues.size() == 1 && termValues.get(0) != null && termValues.get(0).trim().equals(""))) {
                termValues = termValue.getVcardAttributeValues("ORG");
            }
        } else {
            termValues = new ArrayList<String>(1);
            termValues.add(termValue.getValue());
        }
        for (int i = 0; termValues != null && i < termValues.size(); ++i) {
            String lowerCaseValue = value.toLowerCase().trim();
            String lowerCaserTermValue = termValues.get(i).toLowerCase().trim();
            String regexp = VocabularyServiceImpl.getRegexpFromValue(lowerCaserTermValue);
            try {
                if (!lowerCaseValue.matches(regexp)) continue;
                return true;
            }
            catch (PatternSyntaxException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("matches :: regexp=" + regexp + " --> " + e, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public List<String> getLabelsFromValue(String vocabularyId, String value, String vcardAttribute, List<String> availableLanguages, String language, String defaultLanguage) {
        Term term = this.getTermsFromValue(vocabularyId, value, vcardAttribute, availableLanguages, defaultLanguage);
        List<String> labels = this.getLabelsFromTerm(term, language, defaultLanguage);
        return labels;
    }

    @Override
    public List<String> getLabelsFromValue(String vocabularyId, String value, List<String> availableLanguages, String language, String defaultLanguage) {
        return this.getLabelsFromValue(vocabularyId, value, null, availableLanguages, language, defaultLanguage);
    }

    @Override
    public List<String> getLabelsFromTerm(Term term, String language, String defaultLanguage) {
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<Term> termsLeafs = new ArrayList<Term>();
        this.getTermsLeafs(term, termsLeafs);
        for (int i = 0; i < termsLeafs.size(); ++i) {
            Term leaf = (Term)termsLeafs.get(i);
            String label = leaf.getLabel(language, defaultLanguage);
            results.add(label);
        }
        return results;
    }

    private void getTermsLeafs(Term term, List<Term> termsLeafs) {
        if (term != null) {
            if (term.getChildrenSize() == 0) {
                termsLeafs.add(term);
            } else {
                List<Term> children = term.getChildren();
                for (int i = 0; i < children.size(); ++i) {
                    this.getTermsLeafs(children.get(i), termsLeafs);
                }
            }
        }
    }

    @Override
    public List<String> getTermIds(String vocabularyId, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<String> result = new ArrayList<String>();
        Term root = this.getRootTerm(vocabularyId, availableLanguages, defaultLanguage);
        if (root != null) {
            root = root.clone();
            this.getTermIds(root, result);
        }
        return result;
    }

    @Override
    public List<String> getTermIds(Term term) {
        ArrayList<String> result = new ArrayList<String>();
        this.getTermIds(term, result);
        return result;
    }

    private void getTermIds(Term root, List<String> result) {
        String id = root.getId();
        result.add(id);
        List<Term> children = root.getChildren();
        for (int i = 0; children != null && i < children.size(); ++i) {
            this.getTermIds(children.get(i), result);
        }
    }
}

