/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vocabulary.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import org.orioai.commons.vocabulary.Term;
import org.orioai.commons.vocabulary.TermValue;
import org.orioai.commons.vocabulary.service.IVocabularyService;
import org.orioai.commons.vocabulary.service.exceptions.NotFoundVocabularyTermException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockVocabularyServiceImpl
implements IVocabularyService {
    private static Logger log = LoggerFactory.getLogger(MockVocabularyServiceImpl.class);
    private HashMap<String, Term> thematicHierarchies = new HashMap();

    private Term getRootVocabularyTerm(String vocabularyId, List<String> availableLanguages, String defaultLanguage) {
        Term vtc = this.thematicHierarchies.get(vocabularyId);
        ArrayList<String> locales = new ArrayList<String>();
        locales.add("fr");
        locales.add("en");
        locales.add("es");
        if (vtc == null) {
            Term child1 = new Term();
            child1.setId("test1");
            child1.setValue(new TermValue("test1"));
            HashMap<String, String> labels = new HashMap<String, String>();
            labels.put(Locale.FRENCH.getLanguage(), "Test 1");
            child1.setLabels(labels);
            Term child2 = new Term();
            child2.setId("test2");
            child2.setValue(new TermValue("test2"));
            labels = new HashMap();
            labels.put(Locale.FRENCH.getLanguage(), "Test 2");
            child2.setLabels(labels);
            vtc = new Term();
            labels = new HashMap();
            labels.put(Locale.FRENCH.getLanguage(), "Test");
            vtc.setLabels(labels);
            vtc.setId("root");
            vtc.setValue(new TermValue("test"));
            vtc.setTerm(child1);
            vtc.setTerm(child2);
            this.thematicHierarchies.put(vocabularyId, vtc);
        }
        return vtc;
    }

    @Override
    public List<Term> getTermsLeafsFromValue(String vocabularyId, String value, String vcardAttribute, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<Term> terms = new ArrayList<Term>();
        Term last = this.getTerm(vocabularyId, "test2", availableLanguages, defaultLanguage);
        terms.add(0, last);
        for (Term term = last.getParent(); term != null; term = term.getParent()) {
            terms.add(0, term);
        }
        return terms;
    }

    @Override
    public void initRootTerm(String vocabularyId, HashMap<String, List<String>> vocabulariesVcardAttributes, List<String> availableLanguages, String defaultLanguage) {
        this.getRootTerm(vocabularyId, availableLanguages, defaultLanguage);
    }

    @Override
    public Term getRootTerm(String vocabularyId, List<String> availableLanguages, String defaultLanguage) {
        return this.getTerm(vocabularyId, null, availableLanguages, defaultLanguage);
    }

    @Override
    public Term getTerm(String vocabularyId, String id, List<String> availableLanguages, String defaultLanguage) {
        log.debug("getTerm :: Search term with vocabularyId={} ,id={}", (Object)vocabularyId, (Object)id);
        Term rootTerm = this.getRootVocabularyTerm(vocabularyId, availableLanguages, defaultLanguage);
        Term foundTerm = null;
        if (id == null || id.trim().equals("")) {
            foundTerm = rootTerm;
        } else {
            foundTerm = this.searchTerm(rootTerm, id);
            if (foundTerm == null) {
                log.error("getTerm :: Unable find term with vocabularyId=" + vocabularyId + " ,id=" + id);
                throw new NotFoundVocabularyTermException();
            }
        }
        return foundTerm;
    }

    private Term searchTerm(Term vocabularyTerm, String id) {
        if (vocabularyTerm != null) {
            String termId = vocabularyTerm.getId();
            if (termId != null && termId.equals(id)) {
                return vocabularyTerm;
            }
            List<Term> children = vocabularyTerm.getChildren();
            if (children == null || children.size() == 0) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                Term foundCat = this.searchTerm(children.get(i), id);
                if (foundCat == null) continue;
                return foundCat;
            }
            return null;
        }
        return null;
    }

    @Override
    public List<Term> getTermsHierarchy(String vocabularyId, String id, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<Term> terms = new ArrayList<Term>();
        Term last = this.getTerm(vocabularyId, "test2", availableLanguages, defaultLanguage);
        terms.add(0, last);
        for (Term term = last.getParent(); term != null; term = term.getParent()) {
            terms.add(0, term);
        }
        return terms;
    }

    @Override
    public Hashtable<String, String> getVocabularyLabelsFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String language, String defaultLanguage) {
        ArrayList<String> vocabularyIds = new ArrayList<String>();
        vocabularyIds.add(vocabularyId);
        ArrayList<List<String>> allIds = new ArrayList<List<String>>();
        allIds.add(ids);
        return this.getVocabularyLabelsFromIds(vocabularyIds, allIds, availableLanguages, language, defaultLanguage);
    }

    @Override
    public Hashtable<String, String> getVocabularyLabelsFromIds(List<String> vocabularyIds, List<List<String>> allIds, List<String> availableLanguages, String language, String defaultLanguage) {
        Hashtable<String, String> labels = new Hashtable<String, String>();
        for (int i = 0; i < vocabularyIds.size(); ++i) {
            String vocabularyId = vocabularyIds.get(i);
            List<String> ids = allIds.get(i);
            for (int j = 0; j < ids.size(); ++j) {
                String id = ids.get(j);
                labels.put(vocabularyId + "_" + id, "Test_" + vocabularyId + "_" + id);
            }
        }
        return labels;
    }

    @Override
    public List<TermValue> getVocabularyAllValuesFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<TermValue> allValues = new ArrayList<TermValue>();
        allValues.add(new TermValue("Test-1_" + vocabularyId + "_" + ids));
        allValues.add(new TermValue("Test-2_" + vocabularyId + "_" + ids));
        return allValues;
    }

    @Override
    public List<String> getVocabularyAllSimpleValuesFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<String> allValues = new ArrayList<String>();
        allValues.add("Test-1_" + vocabularyId + "_" + ids);
        allValues.add("Test-2_" + vocabularyId + "_" + ids);
        return allValues;
    }

    @Override
    public List<TermValue> getVocabularyNodeValuesFromIds(String vocabularyId, List<String> ids, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<TermValue> allValues = new ArrayList<TermValue>();
        allValues.add(new TermValue("Test-1_" + vocabularyId + "_" + ids));
        allValues.add(new TermValue("Test-2_" + vocabularyId + "_" + ids));
        return allValues;
    }

    @Override
    public List<TermValue> getVocabularyNodeValuesFromId(String vocabularyId, String id, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<TermValue> allValues = new ArrayList<TermValue>();
        allValues.add(new TermValue("Test-1_" + vocabularyId + "_" + id));
        allValues.add(new TermValue("Test-2_" + vocabularyId + "_" + id));
        return allValues;
    }

    @Override
    public Term getTermsFromValue(String vocabularyId, String value, String vcardAttribute, List<String> availableLanguages, String defaultLanguage) {
        return this.getRootTerm(vocabularyId, availableLanguages, defaultLanguage).clone();
    }

    @Override
    public Term getTermsFromValue(String vocabularyId, String value, List<String> availableLanguages, String defaultLanguage) {
        return this.getTermsFromValue(vocabularyId, value, null, availableLanguages, defaultLanguage);
    }

    @Override
    public List<String> getLabelsFromValue(String vocabularyId, String value, String vcardAttribute, List<String> availableLanguages, String language, String defaultLanguage) {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add("Test_" + vocabularyId + "_" + value);
        return result;
    }

    @Override
    public List<String> getLabelsFromValue(String vocabularyId, String value, List<String> availableLanguages, String language, String defaultLanguage) {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add("Test_" + vocabularyId + "_" + value);
        return result;
    }

    @Override
    public List<String> getLabelsFromTerm(Term term, String language, String defaultLanguage) {
        return null;
    }

    @Override
    public List<String> getTermIds(String vocabularyId, List<String> availableLanguages, String defaultLanguage) {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add("Test_" + vocabularyId);
        return result;
    }

    @Override
    public List<String> getTermIds(Term term) {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add("Test");
        return result;
    }
}

