/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.vcard;

import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.vcard4j.java.AddressBook;
import net.sf.vcard4j.java.VCard;
import net.sf.vcard4j.java.type.AGENT;
import net.sf.vcard4j.java.type.BDAY;
import net.sf.vcard4j.java.type.CLASS;
import net.sf.vcard4j.java.type.EMAIL;
import net.sf.vcard4j.java.type.FN;
import net.sf.vcard4j.java.type.KEY;
import net.sf.vcard4j.java.type.LABEL;
import net.sf.vcard4j.java.type.LOGO;
import net.sf.vcard4j.java.type.MAILER;
import net.sf.vcard4j.java.type.N;
import net.sf.vcard4j.java.type.NOTE;
import net.sf.vcard4j.java.type.ORG;
import net.sf.vcard4j.java.type.PHOTO;
import net.sf.vcard4j.java.type.PROID;
import net.sf.vcard4j.java.type.REV;
import net.sf.vcard4j.java.type.ROLE;
import net.sf.vcard4j.java.type.SORT_STRING;
import net.sf.vcard4j.java.type.SOUND;
import net.sf.vcard4j.java.type.TEL;
import net.sf.vcard4j.java.type.TITLE;
import net.sf.vcard4j.java.type.TZ;
import net.sf.vcard4j.java.type.UID;
import net.sf.vcard4j.java.type.URL;
import net.sf.vcard4j.java.type.VERSION;
import net.sf.vcard4j.java.type.X;
import net.sf.vcard4j.parser.DomParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.orioai.commons.exception.VcardException;
import org.orioai.commons.vcard.IVcardService;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class VcardService
implements IVcardService {
    protected static final Log log = LogFactory.getLog(VcardService.class);
    private DomParser globalParser = new DomParser();

    private static String formatVcard(String vcard) {
        String result = "";
        vcard = vcard.trim();
        vcard = vcard.replaceAll("\t", " ");
        while (vcard.indexOf("  ") != -1) {
            vcard = vcard.replaceAll("  ", " ");
        }
        vcard = vcard.replaceAll("\\\\n", "\n");
        vcard = vcard.replaceAll(" ;", ";");
        vcard = vcard.replaceAll("; ", ";");
        vcard = vcard.replaceAll(" :", ":");
        vcard = vcard.replaceAll(": ", ":");
        String[] elements = vcard.split("\n");
        for (int i = 0; i < elements.length; ++i) {
            String toAdd = elements[i].trim();
            if (toAdd.equals("")) continue;
            result = result + toAdd + "\n";
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    @Override
    public List<List<List<String>>> extractAttributeValue(List<String> values, List<String> vcardAttributes) {
        return this.extractAttributeValue(values, vcardAttributes, false);
    }

    @Override
    public List<List<List<String>>> extractAttributeValue(List<String> values, List<String> vcardAttributes, boolean switchNameToOrg) {
        DomParser localParser = new DomParser();
        ArrayList<List<List<String>>> globalResults = new ArrayList<List<List<String>>>();
        for (String value : values) {
            ArrayList<List<String>> valueResults = new ArrayList<List<String>>();
            for (String vcardAttribute : vcardAttributes) {
                try {
                    List<String> attributeValues = this.extractAttributeValue(value, vcardAttribute, localParser, switchNameToOrg);
                    valueResults.add(attributeValues);
                }
                catch (Exception e) {
                    log.debug((Object)("value = " + value + " :: vcardAttribute = " + vcardAttribute + " (" + e.getMessage() + ")"));
                }
                catch (Error e) {
                    log.debug((Object)("value = " + value + " :: vcardAttribute = " + vcardAttribute + " (" + e.getMessage() + ")"));
                }
            }
            globalResults.add(valueResults);
        }
        return globalResults;
    }

    @Override
    public List<String> extractAttributeValue(String value, String vcardAttribute) throws VcardException {
        return this.extractAttributeValue(value, vcardAttribute, false);
    }

    @Override
    public List<String> extractAttributeValue(String value, String vcardAttribute, boolean switchNameToOrg) throws VcardException {
        return this.extractAttributeValue(value, vcardAttribute, this.globalParser, switchNameToOrg);
    }

    private List<String> extractAttributeValue(String value, String vcardAttribute, DomParser parser, boolean switchNameToOrg) throws VcardException {
        if (value.toLowerCase().indexOf("begin:vcard") == -1 || value.toLowerCase().indexOf("end:vcard") == -1) {
            return null;
        }
        String transformedValue = VcardService.formatVcard(value);
        List<String> results = new ArrayList<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("transformedValue = " + transformedValue));
        }
        DocumentImpl document = new DocumentImpl();
        try {
            parser.parse(transformedValue, (Node)document);
        }
        catch (Exception e) {
            throw new VcardException("vcardAttribute = " + vcardAttribute + " value = " + value + " (" + e.getMessage() + ")");
        }
        catch (Error e) {
            throw new VcardException("vcardAttribute = " + vcardAttribute + " value = " + value + " (" + e.getMessage() + ")");
        }
        AddressBook addressBook = new AddressBook(document);
        Iterator vcards = addressBook.getVCards();
        while (vcards.hasNext()) {
            VCard vcard = (VCard)vcards.next();
            Iterator objects = vcard.getTypes(vcardAttribute);
            while (objects.hasNext()) {
                Object object = objects.next();
                String localValue = null;
                if (object instanceof N) {
                    N nAttribute = (N)object;
                    if (nAttribute != null) {
                        String familyName = nAttribute.getFamily();
                        String given = nAttribute.getGiven();
                        localValue = "";
                        if (familyName != null && !"".equals(familyName.trim())) {
                            localValue = familyName.trim() + " ";
                        }
                        if (given != null && !"".equals(given.trim())) {
                            localValue = localValue + given.trim();
                        }
                        localValue = localValue.trim();
                    }
                } else if (object instanceof FN) {
                    localValue = ((FN)object).get();
                } else if (object instanceof ORG) {
                    ORG orgAttribute = (ORG)object;
                    if (orgAttribute != null) {
                        String orgName = orgAttribute.getOrgname();
                        String orgUnit = orgAttribute.getOrgunit();
                        String orgUnit2 = orgAttribute.getOrgunit2();
                        String orgUnit3 = orgAttribute.getOrgunit3();
                        String orgUnit4 = orgAttribute.getOrgunit4();
                        String orgUnit5 = orgAttribute.getOrgunit5();
                        localValue = "";
                        if (orgName != null && !"".equals(orgName.trim())) {
                            localValue = orgName.trim() + ";";
                        }
                        if (orgUnit != null && !"".equals(orgUnit.trim())) {
                            localValue = localValue + orgUnit.trim() + ";";
                        }
                        if (orgUnit2 != null && !"".equals(orgUnit2.trim())) {
                            localValue = localValue + orgUnit2.trim() + ";";
                        }
                        if (orgUnit3 != null && !"".equals(orgUnit3.trim())) {
                            localValue = localValue + orgUnit3.trim() + ";";
                        }
                        if (orgUnit4 != null && !"".equals(orgUnit4.trim())) {
                            localValue = localValue + orgUnit4.trim() + ";";
                        }
                        if (orgUnit5 != null && !"".equals(orgUnit5.trim())) {
                            localValue = localValue + orgUnit5.trim();
                        }
                        if (localValue.endsWith(";")) {
                            localValue = localValue.substring(0, localValue.length() - 1);
                        }
                    }
                } else if (object instanceof AGENT) {
                    localValue = ((AGENT)object).get();
                } else if (object instanceof BDAY) {
                    localValue = ((BDAY)object).get().toString();
                } else if (object instanceof CLASS) {
                    localValue = ((CLASS)object).get();
                } else if (object instanceof EMAIL) {
                    localValue = ((EMAIL)object).get();
                } else if (object instanceof KEY) {
                    localValue = ((KEY)object).get();
                } else if (object instanceof LABEL) {
                    localValue = ((LABEL)object).get();
                } else if (object instanceof LOGO) {
                    localValue = ((LOGO)object).get();
                } else if (object instanceof MAILER) {
                    localValue = ((MAILER)object).get();
                } else if (object instanceof NOTE) {
                    localValue = ((NOTE)object).get();
                } else if (object instanceof PHOTO) {
                    localValue = ((PHOTO)object).get();
                } else if (object instanceof PROID) {
                    localValue = ((PROID)object).get();
                } else if (object instanceof REV) {
                    localValue = ((REV)object).get();
                } else if (object instanceof ROLE) {
                    localValue = ((ROLE)object).get();
                } else if (object instanceof SORT_STRING) {
                    localValue = ((SORT_STRING)object).get();
                } else if (object instanceof SOUND) {
                    localValue = ((SOUND)object).get();
                } else if (object instanceof TEL) {
                    localValue = ((TEL)object).get();
                } else if (object instanceof TITLE) {
                    localValue = ((TITLE)object).get();
                } else if (object instanceof TZ) {
                    localValue = ((TZ)object).get();
                } else if (object instanceof UID) {
                    localValue = ((UID)object).get();
                } else if (object instanceof URL) {
                    localValue = ((URL)object).get();
                } else if (object instanceof VERSION) {
                    localValue = ((VERSION)object).get();
                } else if (object instanceof X) {
                    localValue = ((X)object).get();
                }
                if (localValue != null && !"".equals(localValue.trim())) {
                    results.add(localValue.trim());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("vcardAttribute=" + vcardAttribute + ", localValue=" + localValue));
                }
                if (!results.isEmpty() || !"N".equals(vcardAttribute) || !switchNameToOrg) continue;
                results = this.extractAttributeValue(value, "ORG");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("results=" + results));
        }
        return results;
    }

    @Override
    public String getXmlVcard(String vcard) throws VcardException {
        String transformedValue = VcardService.formatVcard(vcard);
        DomParser parser = this.globalParser;
        DocumentImpl document = new DocumentImpl();
        try {
            parser.parse(transformedValue, (Node)document);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new VcardException(e.getMessage());
        }
        catch (Error e) {
            log.debug((Object)e);
            throw new VcardException(e.getMessage());
        }
        OutputFormat format = new OutputFormat((Document)document);
        format.setOmitDocumentType(true);
        format.setOmitXMLDeclaration(true);
        format.setMethod("xml");
        format.setIndenting(true);
        format.setPreserveSpace(false);
        format.setLineWidth(0);
        StringWriter sw = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)sw, format);
        try {
            serializer.serialize((Document)document);
        }
        catch (IOException e) {
            log.debug((Object)e);
            throw new VcardException(e.getMessage());
        }
        return sw.getBuffer().toString();
    }

    @Override
    public String normalizeAttributeN(String value) {
        String newValue = "";
        String[] valueElements = value.split(";");
        for (int i = 0; i < 2 && i < valueElements.length; ++i) {
            if (valueElements[i].equals("")) continue;
            newValue = newValue + valueElements[i];
            newValue = newValue + " ";
        }
        return newValue.trim();
    }
}

