/*
 * Decompiled with CFR 0.152.
 */
package org.orioai.commons.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.orioai.commons.utils.xml.XMLExplorer;
import org.orioai.ws.vocabulary.IVocabularyService;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLVocabExplorer
extends XMLExplorer {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected IVocabularyService vocabService;

    public IVocabularyService getVocabService() {
        return this.vocabService;
    }

    public Document getDocumentRoot(String vocabularyId) {
        Document result = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream inputStream = this.getVocabInputStream(vocabularyId);
            result = builder.parse(inputStream);
        }
        catch (Exception e) {
            this.logger.error((Object)("can't get document from vocab with id : " + vocabularyId), (Throwable)e);
        }
        return result;
    }

    public NodeList getVocabNodesFromTagNameNS(String vocabularyId, String localName, String namespaceURI) {
        NodeList result = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream inputStream = this.getVocabInputStream(vocabularyId);
            Document doc = builder.parse(inputStream);
            result = doc.getElementsByTagName(localName);
        }
        catch (Exception e) {
            this.logger.error((Object)("can't get nodes from vocab with id : " + vocabularyId + " for tag " + localName), (Throwable)e);
        }
        return result;
    }

    public List<String> getVocabValuesFromTagNameNS(String vocabularyId, String localName, String namespaceURI) {
        List<String> result = null;
        try {
            NodeList nodeList = this.getVocabNodesFromTagNameNS(vocabularyId, localName, namespaceURI);
            if (nodeList != null) {
                result = this.fillStringListFromNodeList(nodeList);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("can't parse vocab with id : " + vocabularyId + " for tag " + localName), (Throwable)e);
        }
        return result;
    }

    public NodeList getVocabNodesFromXPath(String vocabularyId, String xpath) {
        NodeList result = null;
        InputStream inputStream = this.getVocabInputStream(vocabularyId);
        InputSource source = new InputSource(inputStream);
        try {
            XPath environnement = this.xPathFactory.newXPath();
            XPathExpression expression = environnement.compile(xpath);
            result = (NodeList)expression.evaluate(source, XPathConstants.NODESET);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for vocabulary id :" + vocabularyId), (Throwable)e);
        }
        return result;
    }

    public List<String> getVocabValuesFromXPath(String vocabularyId, String xpath) {
        List<String> result = null;
        try {
            NodeList nodeList = this.getVocabNodesFromXPath(vocabularyId, xpath);
            result = this.fillStringListFromNodeList(nodeList);
        }
        catch (Exception e) {
            this.logger.debug((Object)("can't evaluate XPATH expression :" + xpath + " for vocabulary id :" + vocabularyId));
        }
        return result;
    }

    private InputStream getVocabInputStream(String vocabularyId) {
        ByteArrayInputStream inputStream = null;
        String vocab = this.vocabService.getVocabulary(vocabularyId);
        try {
            inputStream = new ByteArrayInputStream(vocab.getBytes("UTF-8"));
        }
        catch (Exception e) {
            this.logger.error((Object)("can't get inputstream for vocabulary :" + vocabularyId), (Throwable)e);
        }
        return inputStream;
    }

    public void setVocabService(IVocabularyService vocabService) {
        this.vocabService = vocabService;
    }
}

