/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.util;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.util.Iterator;
import net.sf.vcard4j.util.NodeIterator;
import net.sf.vcard4j.util.NodeValueIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XpathUtil {
    public static Node getType(Element vcard, String typeName) {
        NodeList list = vcard.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            if (!element.getNodeName().equals("type") || !element.getAttribute("name").equals(typeName)) continue;
            return element;
        }
        return null;
    }

    public static Node getNode(Node node, String xpath) {
        try {
            return XPathAPI.selectSingleNode(node, xpath);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Node[] getNodeArray(Node node, String xpath) {
        try {
            NodeList nl = XPathAPI.selectNodeList(node, xpath);
            int l = nl.getLength();
            Node[] result = new Node[l];
            for (int i = 0; i < l; ++i) {
                result[i] = nl.item(i);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Iterator getNodeIterator(Node node, String xpath) {
        try {
            return new NodeIterator(XPathAPI.selectNodeList(node, xpath));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getValue(Node node, String xpath) {
        Node toto = XpathUtil.getNode(node, xpath);
        if (toto == null) {
            return null;
        }
        return toto.getNodeValue();
    }

    public static String[] getValueArray(Node node, String xpath) {
        Node[] toto = XpathUtil.getNodeArray(node, xpath);
        String[] result = new String[toto.length];
        for (int i = 0; i < toto.length; ++i) {
            result[i] = toto[i].getNodeValue();
        }
        return result;
    }

    public static Iterator getValueIterator(Node node, String xpath) {
        try {
            return new NodeValueIterator(XPathAPI.selectNodeList(node, xpath));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

