/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.search;

import java.util.HashSet;
import java.util.Set;
import net.sf.vcard4j.search.Query;
import org.w3c.dom.Node;

public class BinaryQuery
implements Query {
    public static final boolean AND = true;
    public static final boolean OR = false;
    private Query leftQuery = null;
    private Query rightQuery = null;
    private boolean operator = true;
    private Set resultingVcards = new HashSet();
    private Set resultingTypes = new HashSet();

    public void setLeftOperand(Query query) {
        this.leftQuery = query;
    }

    public void setRightOperand(Query query) {
        this.rightQuery = query;
    }

    public Query getLeftOperand() {
        return this.leftQuery;
    }

    public Query getRightOperand() {
        return this.rightQuery;
    }

    public void setOperator(boolean v) {
        this.operator = v;
    }

    @Override
    public boolean search(Node root) {
        this.resultingVcards.clear();
        this.resultingTypes.clear();
        this.leftQuery.search(root);
        this.rightQuery.search(root);
        if (this.operator) {
            this.resultingVcards.addAll(this.leftQuery.getMatchingVCards());
            this.resultingVcards.retainAll(this.rightQuery.getMatchingVCards());
            this.resultingTypes.addAll(this.leftQuery.getMatchingTypes());
            this.resultingTypes.addAll(this.rightQuery.getMatchingTypes());
        } else {
            this.resultingVcards.addAll(this.leftQuery.getMatchingVCards());
            this.resultingVcards.addAll(this.rightQuery.getMatchingVCards());
            this.resultingTypes.addAll(this.leftQuery.getMatchingTypes());
            this.resultingTypes.addAll(this.rightQuery.getMatchingTypes());
        }
        return this.resultingVcards.size() > 0;
    }

    @Override
    public Set getMatchingVCards() {
        return new HashSet(this.resultingVcards);
    }

    @Override
    public Set getMatchingTypes() {
        return new HashSet(this.resultingTypes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("( ");
        sb.append(this.leftQuery);
        sb.append(" )");
        if (this.operator) {
            sb.append(" AND ");
        } else {
            sb.append(" OR ");
        }
        sb.append("( ");
        sb.append(this.rightQuery);
        sb.append(" )");
        return sb.toString();
    }
}

