/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.parser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.vcard4j.parser.EscapableStringTokenizer;
import net.sf.vcard4j.parser.VCardException;
import net.sf.vcard4j.parser.VCardParseException;
import net.sf.vcard4j.util.XpathUtil;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomParser {
    public static final String RELEASE_DATE = "2003.11.05";
    public static final String VERSION = "1.1.3";
    public static final String BEGIN_VCARD = "BEGIN:VCARD";
    public static final String END_VCARD = "END:VCARD";
    public static final char GROUP_DELIMITER = '.';
    public static final char VALUE_DELIMITER = ':';
    public static final char PARAMETER_DELIMITER = ';';
    public static final char STRUCTURE_DELIMITER = ';';
    public static final char ITEM_DELIMITER = ',';
    public static final String XML_ADDRESS_BOOK = "addressBook";
    public static final String XML_VCARD = "vcard";
    public static final String XML_GROUP = "group";
    public static final String XML_TYPE = "type";
    public static final String XML_PARAMETER = "parameter";
    public static final String XML_VALUE = "value";
    public static final String XML_LIST_ITEM = "listItem";
    public static final String XML_STRUCTURED_ITEM = "structuredItem";
    public static final String XML_TEXT = "text";
    public static final int DEFAULT_VCARD_LENGTH = 1000;
    private Document document;
    private Document configuration;
    List mandatory = null;
    Map formats = new HashMap();

    public Document getDomConfiguration() {
        return this.configuration;
    }

    public DomParser() {
        this.init();
    }

    public DomParser(InputSource input) throws SAXException, IOException {
        if (input != null) {
            this.init(input);
        } else {
            this.init();
        }
    }

    public DomParser(File file) throws SAXException, IOException {
        if (file != null) {
            this.init(file);
        } else {
            this.init();
        }
    }

    public DomParser(URL url) throws SAXException, IOException {
        if (url != null) {
            this.init(url);
        } else {
            this.init();
        }
    }

    public DomParser(Document configuration) {
        if (configuration != null) {
            this.init(configuration);
        } else {
            this.init();
        }
    }

    private void init() {
        String file = null;
        file = System.getProperty("vcard4j.configuration");
        if (file == null) {
            file = System.getProperty("user.dir") + "/cfg/vcard4j-cfg.xml";
        }
        try {
            this.init(new File(file));
        }
        catch (Exception e0) {
            try {
                this.init(new URL(file));
            }
            catch (Exception e1) {
                try {
                    InputStream in = this.getClass().getResourceAsStream("vcard4j-cfg.xml");
                    this.init(new InputSource(in));
                    in.close();
                }
                catch (Exception e2) {
                    throw new RuntimeException("Could not locate configuration file: " + file, e0);
                }
            }
        }
    }

    private void init(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        this.init(new InputSource(in));
        ((InputStream)in).close();
    }

    private void init(URL url) throws SAXException, IOException {
        InputStream in = url.openStream();
        this.init(new InputSource(in));
        in.close();
    }

    private void init(InputSource input) throws SAXException, IOException {
        DOMParser parser = new DOMParser();
        parser.parse(input);
        this.init(parser.getDocument());
    }

    private void init(Document configuration) {
        if (configuration == null) {
            throw new NullPointerException("Missing configuration document");
        }
        this.configuration = configuration;
    }

    public void parse(InputStream vcardStream, Node resultingDom) throws VCardParseException, IOException {
        this.parse(vcardStream, 1000, resultingDom);
    }

    public void parse(InputStream vcardStream, int vcardLength, Node resultingDom) throws VCardParseException, IOException {
        this.parse(new BufferedReader(new InputStreamReader(vcardStream)), vcardLength, resultingDom);
    }

    public void parse(Reader vcardReader, Node resultingDom) throws VCardParseException, IOException {
        this.parse(vcardReader, 1000, resultingDom);
    }

    public void parse(Reader vcardReader, int vcardLength, Node resultingDom) throws VCardParseException, IOException {
        this.parse(new BufferedReader(vcardReader), vcardLength, resultingDom);
    }

    public void parse(String vcard, Node resultingDom) throws VCardParseException, IOException {
        int vcardLength = 0;
        if (vcard != null) {
            vcardLength = vcard.length();
        }
        this.parse(new StringReader(vcard), vcardLength, resultingDom);
    }

    public void parse(BufferedReader reader, int vcardLength, Node resultingDom) throws VCardParseException, IOException {
        String line;
        ByteArrayOutputStream out = null;
        Writer writer = null;
        Element addressBook = null;
        this.document = resultingDom.getOwnerDocument();
        if (this.document == null) {
            this.document = (Document)resultingDom;
        }
        while ((line = this.nextLine(reader, vcardLength)) != null) {
            if (line.equalsIgnoreCase(BEGIN_VCARD)) {
                if (out != null) {
                    this.throwParseException("Unexpected declaration, vCard not terminated: " + line);
                }
                out = new ByteArrayOutputStream();
                writer = new BufferedWriter(new OutputStreamWriter(out));
                writer.write(line);
                ((BufferedWriter)writer).newLine();
                continue;
            }
            if (line.equalsIgnoreCase(END_VCARD)) {
                if (out == null) {
                    this.throwParseException("Unexpected declaration, no vCard declared: " + line);
                }
                writer.write(line);
                ((BufferedWriter)writer).newLine();
                ((BufferedWriter)writer).flush();
                if (addressBook == null) {
                    if (XML_ADDRESS_BOOK.equals(resultingDom.getNodeValue())) {
                        addressBook = (Element)resultingDom;
                    } else {
                        addressBook = this.document.createElement(XML_ADDRESS_BOOK);
                        this.document.appendChild(addressBook);
                    }
                }
                Element vcard = this.parseVCard(new ByteArrayInputStream(out.toByteArray()), vcardLength);
                addressBook.appendChild(vcard);
                try {
                    out.close();
                    ((BufferedWriter)writer).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                out = null;
                writer = null;
                continue;
            }
            if (out == null) {
                this.throwParseException("Expecting declaration, no vCard declared: " + line);
            }
            writer.write(line);
            ((BufferedWriter)writer).newLine();
        }
        if (out != null) {
            this.throwParseException("Unexpected end of stream: vCard not terminated");
        }
    }

    protected Element parseVCard(InputStream stream, int vcardLength) throws IOException, VCardParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Element vcard = this.document.createElement(XML_VCARD);
        String line = this.nextLine(reader, vcardLength);
        if (!line.equalsIgnoreCase(BEGIN_VCARD)) {
            this.throwParseException("Expecting vCard declaration: " + line);
        }
        while (line != null && !(line = this.nextLine(reader, vcardLength)).equalsIgnoreCase(END_VCARD)) {
            Element type = this.parseType(line);
            vcard.appendChild(type);
        }
        if (line == null) {
            this.throwParseException("Unexpected end of stream: vCard not terminated");
        }
        this.checkVcard(vcard);
        return vcard;
    }

    protected void checkVcard(Element vcard) {
        String version = DomParser.getVersion(vcard);
        if (version == null) {
            this.convertVcard21(vcard);
            return;
        }
        if ("2.1".equals(version)) {
            this.convertVcard21(vcard);
            return;
        }
        if ("3.0".equals(version)) {
            this.checkVcard30(vcard);
            return;
        }
        throw new VCardException("Invalid version: " + version);
    }

    public static String getVersion(Element vcard) {
        String version = null;
        NodeList types = vcard.getChildNodes();
        for (int i = 0; i < types.getLength(); ++i) {
            Element type = (Element)types.item(i);
            if (!type.getNodeName().equals(XML_TYPE) || !type.getAttribute("name").equals("VERSION")) continue;
            if (version != null) {
                throw new VCardException("Expecting only 1 version");
            }
            Node value = type.getFirstChild();
            if (!value.getNodeName().equals(XML_VALUE)) {
                throw new VCardException("Expecting 'value' element");
            }
            Node text = value.getFirstChild();
            if (!text.getNodeName().equals(XML_TEXT)) {
                throw new VCardException("Expecting 'text' element");
            }
            version = text.getFirstChild().getNodeValue();
        }
        return version;
    }

    protected void checkVcard30(Element vcard) {
        Iterator mandatoryTypes = this.getMandatoryTypes();
        while (mandatoryTypes.hasNext()) {
            String typeName = (String)mandatoryTypes.next();
            if (XpathUtil.getType(vcard, typeName) != null) continue;
            throw new VCardException("Missing mandatory type: " + typeName);
        }
    }

    public Iterator getMandatoryTypes() {
        if (this.mandatory == null) {
            this.mandatory = new ArrayList();
            Iterator it = XpathUtil.getValueIterator(this.configuration, "/vcard4jConfiguration/type[@mandatory='true']/@name");
            while (it.hasNext()) {
                this.mandatory.add(it.next());
            }
        }
        return this.mandatory.iterator();
    }

    protected void convertVcard21(Element vcard) {
        Text text;
        Element node1;
        Element node0;
        Node versionNode = XpathUtil.getType(vcard, "VERSION");
        if (versionNode == null) {
            node0 = this.document.createElement(XML_TYPE);
            node0.setAttribute("name", "VERSION");
            vcard.appendChild(node0);
            node1 = this.document.createElement(XML_VALUE);
            node0.appendChild(node1);
            node0 = this.document.createElement(XML_TEXT);
            node1.appendChild(node0);
            text = this.document.createTextNode("3.0");
            node0.appendChild(text);
        } else {
            text = (Text)XpathUtil.getNode(versionNode, "value/text/text()");
            text.setData("3.0");
        }
        Node n = XpathUtil.getType(vcard, "N");
        Node fn = XpathUtil.getType(vcard, "FN");
        if (n != null && fn == null) {
            node0 = this.document.createElement(XML_TYPE);
            node0.setAttribute("name", "FN");
            vcard.appendChild(node0);
            node1 = this.document.createElement(XML_VALUE);
            node0.appendChild(node1);
            node0 = this.document.createElement(XML_TEXT);
            node1.appendChild(node0);
            String[] n01 = new String[]{XpathUtil.getValue(n, "value/structuredItem[1]/listItem/text/text()"), XpathUtil.getValue(n, "value/structuredItem[2]/listItem/text/text()")};
            if (n01[0] == null) {
                n01[0] = "";
            }
            if (n01[1] == null) {
                n01[1] = "";
            }
            String toto = n01[0].length() == 0 ? n01[1] : (n01[1].length() == 0 ? n01[0] : n01[1] + " " + n01[0]);
            Text text2 = this.document.createTextNode(toto);
            node0.appendChild(text2);
        } else if (n == null && fn != null) {
            String family;
            String toto = XpathUtil.getValue(fn, "value/text/text()");
            int index = toto.lastIndexOf(32);
            String given = null;
            if (index > 0) {
                family = toto.substring(index + 1);
                given = toto.substring(0, index);
            } else {
                family = toto;
            }
            n = this.document.createElement(XML_TYPE);
            ((Element)n).setAttribute("name", "N");
            vcard.appendChild(n);
            node1 = this.document.createElement(XML_STRUCTURED_ITEM);
            n.appendChild(node1);
            node0 = this.document.createElement(XML_LIST_ITEM);
            node1.appendChild(node0);
            node1 = this.document.createElement(XML_VALUE);
            node0.appendChild(node1);
            node0 = this.document.createElement(XML_TEXT);
            node1.appendChild(node0);
            Text text3 = this.document.createTextNode(family);
            node0.appendChild(text3);
            if (given != null) {
                node1 = this.document.createElement(XML_STRUCTURED_ITEM);
                n.appendChild(node1);
                node0 = this.document.createElement(XML_LIST_ITEM);
                node1.appendChild(node0);
                node1 = this.document.createElement(XML_VALUE);
                node0.appendChild(node1);
                node0 = this.document.createElement(XML_TEXT);
                node1.appendChild(node0);
                text3 = this.document.createTextNode(given);
                node0.appendChild(text3);
            }
        } else if (n == null && fn == null && n == null) {
            throw new VCardException("Missing both mandatory type: N and FN");
        }
    }

    protected Element parseType(String line) throws VCardParseException {
        String name;
        Element type = this.document.createElement(XML_TYPE);
        int index = line.indexOf(58);
        if (index < 0) {
            this.throwParseException("No value defined for this type: " + line);
        }
        String valueString = line.substring(index + 1);
        if ((index = (line = line.substring(0, index)).indexOf(59)) >= 0) {
            Element[] parameters = this.parseParameters(line.substring(index + 1));
            for (int i = 0; i < parameters.length; ++i) {
                type.appendChild(parameters[i]);
            }
            name = line.substring(0, index);
        } else {
            name = line;
        }
        index = name.indexOf(46);
        if (index >= 0) {
            type.setAttribute(XML_GROUP, name.substring(0, index));
            name = name.substring(index + 1);
        }
        name = name.toUpperCase();
        type.setAttribute("name", name);
        String format = this.getFormat(name);
        Element value = null;
        if (format != null) {
            if (format.equals("list")) {
                value = this.parseValueList(valueString);
            } else if (format.equals("structured")) {
                int structureSize = XpathUtil.getNodeArray(this.configuration, "/vcard4jConfiguration/type[@name='" + name + "']/value").length;
                value = this.parseStructuredValue(valueString, structureSize);
            } else {
                value = format.equals("single") ? this.parseSingleValue(valueString) : this.parseSingleValue(valueString);
            }
        } else {
            value = this.parseSingleValue(valueString);
        }
        type.appendChild(value);
        return type;
    }

    public String getFormat(String name) {
        String format = (String)this.formats.get(name);
        if (format != null) {
            return format;
        }
        format = XpathUtil.getValue(this.configuration, "/vcard4jConfiguration/type[@name='" + name + "']/@format");
        this.formats.put(name, format);
        return format;
    }

    protected Element parseSingleValue(String s) {
        Element value = this.document.createElement(XML_VALUE);
        Element text = this.document.createElement(XML_TEXT);
        Text textString = this.document.createTextNode(EscapableStringTokenizer.unescape(s));
        text.appendChild(textString);
        value.appendChild(text);
        return value;
    }

    protected Element parseValueList(String s) {
        Element value = this.document.createElement(XML_VALUE);
        EscapableStringTokenizer st = new EscapableStringTokenizer(s, ',', true);
        while (st.hasNext()) {
            String str = st.nextToken();
            if (str.length() <= 0) continue;
            Element item = this.document.createElement(XML_LIST_ITEM);
            Element text = this.document.createElement(XML_TEXT);
            Text textString = this.document.createTextNode(str);
            text.appendChild(textString);
            item.appendChild(text);
            value.appendChild(item);
        }
        return value;
    }

    protected Element parseStructuredValue(String s, int size) {
        Text textString;
        Element text;
        Element listItem;
        Element structuredItem;
        Element value = this.document.createElement(XML_VALUE);
        int index = 0;
        EscapableStringTokenizer sts = new EscapableStringTokenizer(s, ';', false);
        while (sts.hasNext()) {
            structuredItem = this.document.createElement(XML_STRUCTURED_ITEM);
            EscapableStringTokenizer stl = new EscapableStringTokenizer(sts.nextToken(), ',', true);
            while (stl.hasNext()) {
                listItem = this.document.createElement(XML_LIST_ITEM);
                text = this.document.createElement(XML_TEXT);
                textString = this.document.createTextNode(stl.nextToken());
                text.appendChild(textString);
                listItem.appendChild(text);
                structuredItem.appendChild(listItem);
            }
            value.appendChild(structuredItem);
            ++index;
        }
        while (index < size) {
            structuredItem = this.document.createElement(XML_STRUCTURED_ITEM);
            listItem = this.document.createElement(XML_LIST_ITEM);
            text = this.document.createElement(XML_TEXT);
            textString = this.document.createTextNode("");
            text.appendChild(textString);
            listItem.appendChild(text);
            structuredItem.appendChild(listItem);
            value.appendChild(structuredItem);
            ++index;
        }
        return value;
    }

    protected Element[] parseParameters(String parameterString) {
        StringTokenizer st0 = new StringTokenizer(parameterString, ";");
        ArrayList<Element> parameters = new ArrayList<Element>();
        while (st0.hasMoreTokens()) {
            StringTokenizer st1;
            String key;
            String toto = st0.nextToken();
            int index = toto.indexOf("=");
            if (index > 0) {
                key = toto.substring(0, index);
                st1 = new StringTokenizer(toto.substring(index + 1), ",");
            } else {
                key = "TYPE";
                st1 = new StringTokenizer(toto, ",");
            }
            while (st1.hasMoreElements()) {
                Element parameter = this.document.createElement(XML_PARAMETER);
                parameter.setAttribute("name", key.toUpperCase());
                parameter.setAttribute(XML_VALUE, st1.nextToken().toUpperCase());
                parameters.add(parameter);
            }
        }
        return parameters.toArray(new Element[parameters.size()]);
    }

    protected String nextLine(BufferedReader reader, int vcardLength) throws IOException {
        String line;
        do {
            if ((line = reader.readLine()) != null) continue;
            return null;
        } while (line.length() == 0);
        while (line.endsWith("=")) {
            line = line.substring(0, line.length() - 1);
            line = line + reader.readLine();
        }
        reader.mark(vcardLength);
        String nextLine = reader.readLine();
        if (nextLine != null && nextLine.length() > 0 && (nextLine.charAt(0) == ' ' || nextLine.charAt(0) == '\t')) {
            line = line + nextLine.substring(1);
        } else {
            reader.reset();
        }
        line = line.trim();
        return line;
    }

    protected void throwParseException(String message) throws VCardParseException {
        throw new VCardParseException(message);
    }

    protected void throwVCardException(String message) {
        throw new VCardException(message);
    }
}

