/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.java.type.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class VDate {
    private Calendar calendar = new GregorianCalendar();
    private int thisYear = this.calendar.get(1);

    public VDate() {
        this.setDate(System.currentTimeMillis());
    }

    public VDate(String value) {
        this();
        this.setDate(value);
    }

    public void setDate(Date date) {
        this.calendar.setTime(date);
    }

    public void setDate(long date) {
        this.calendar.setTimeInMillis(date);
    }

    public void setDate(int year, int month, int day) {
        if (year >= 0 && year < 100 && (year += this.thisYear / 100) > this.thisYear) {
            year -= 100;
        }
        this.calendar.set(year, month - 1, day);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public void setDate(String value) {
        int indexDash = value.indexOf("-");
        int year = Integer.parseInt(value.substring(0, indexDash));
        value = value.substring(indexDash + 1);
        indexDash = value.indexOf("-");
        int month = Integer.parseInt(value.substring(0, indexDash));
        value = value.substring(indexDash + 1);
        indexDash = value.indexOf("T");
        int day = Integer.parseInt(value.substring(0, indexDash));
        this.calendar.set(year, month - 1, day);
    }

    public String toString() {
        String day;
        String year = "" + this.calendar.get(1);
        String month = "" + (this.calendar.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = "" + this.calendar.get(5)).length() == 1) {
            day = "0" + day;
        }
        return year + "-" + month + "-" + day;
    }
}

