/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.java;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.vcard4j.util.XpathUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Parameters {
    protected final Map PARAMETER_VALUES = new HashMap();
    private Element type;

    protected String convert(String typeName, int value) {
        return ((String[])this.PARAMETER_VALUES.get(typeName))[value];
    }

    protected int convert(String typeName, String value) {
        String[] values = (String[])this.PARAMETER_VALUES.get(typeName);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equalsIgnoreCase(value)) continue;
            return i;
        }
        return -1;
    }

    protected Element getElement() {
        return this.type;
    }

    private Parameters() {
    }

    public Parameters(Element type) {
        this.type = type;
    }

    protected void add(String parameterName, int value) {
        Element parameter = (Element)XpathUtil.getNode(this.type, "parameter[@name='" + parameterName + "' and @value='" + this.convert(parameterName, value) + "']");
        if (parameter != null) {
            return;
        }
        parameter = this.type.getOwnerDocument().createElement("parameter");
        parameter.setAttribute("name", parameterName);
        parameter.setAttribute("value", this.convert(parameterName, value));
        this.type.appendChild(parameter);
    }

    protected void remove(String parameterName, int value) {
        Node parameter = XpathUtil.getNode(this.type, "parameter[@name='" + parameterName + "' and @value='" + this.convert(parameterName, value) + "']");
        if (parameter != null) {
            return;
        }
        this.type.removeChild(parameter);
    }

    protected Iterator iterator(String parameterName) {
        return new PIterator(parameterName);
    }

    protected boolean contains(String parameterName, int value) {
        return XpathUtil.getNode(this.type, "parameter[@name='" + parameterName + "' and @value='" + this.convert(parameterName, value) + "']") != null;
    }

    protected void clear(String parameterName) {
        Iterator it = XpathUtil.getNodeIterator(this.type, "parameter[@name='" + parameterName + "']");
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    protected void clear() {
        Iterator it = XpathUtil.getNodeIterator(this.type, "parameter");
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    protected class PIterator
    implements Iterator {
        String typeName;
        Iterator iterator;
        Node node = null;

        protected PIterator(String parameterName) {
            this.iterator = XpathUtil.getNodeIterator(Parameters.this.type, "parameter[@name='" + parameterName + "']");
            this.typeName = parameterName;
        }

        @Override
        public void remove() {
            this.node.getParentNode().removeChild(this.node);
            this.node = null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.node = (Node)this.iterator.next();
            try {
                return new Integer(Parameters.this.convert(this.typeName, XpathUtil.getValue(this.node, "@value")));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

