/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vcard4j.compiler;

import java.io.PrintWriter;
import net.sf.vcard4j.compiler.GenericTypeCompiler;
import net.sf.vcard4j.util.XpathUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructuredTypeCompiler
extends GenericTypeCompiler {
    @Override
    public void print(Element type, PrintWriter out) {
        int i;
        String typeName = this.getJavaName(XpathUtil.getValue(type, "@name"));
        String description = XpathUtil.getValue(type, "description/text()");
        Node[] values = XpathUtil.getNodeArray(type, "value");
        String[] valueTypes = new String[values.length];
        for (i = 0; i < values.length; ++i) {
            valueTypes[i] = XpathUtil.getValue(values[i], "implementation/@className");
            if (valueTypes[i] != null) continue;
            valueTypes[i] = "java.lang.String";
        }
        out.println("package " + this.packageName + ";");
        out.println();
        out.println("import org.w3c.dom.*;");
        out.println("import net.sf.vcard4j.java.*;");
        out.println("import java.lang.reflect.*;");
        out.println();
        out.println("/**");
        if (description != null) {
            out.println(" * " + description.trim());
        }
        out.println(" * ");
        out.println(" * @author generated by " + this.getClass().getName());
        out.println(" */");
        out.println("public class " + typeName + " extends StructuredType {");
        out.println();
        out.println("  protected static final Constructor valueTypeConstructors[];");
        out.println("  static {");
        out.println("    try {");
        out.println("      valueTypeConstructors = new Constructor[" + values.length + "];");
        for (i = 0; i < valueTypes.length; ++i) {
            out.println("      valueTypeConstructors[" + i + "] = " + valueTypes[i] + ".class.getConstructor(new Class[] { String.class });");
        }
        out.println("    } catch (Exception e) {");
        out.println("      throw new RuntimeException(e);");
        out.println("    }");
        out.println("  }");
        out.println();
        out.println("  public " + typeName + "(Element type) {");
        out.println("    super(type);");
        out.println("  }");
        out.println();
        for (i = 0; i < values.length; ++i) {
            String valueName = XpathUtil.getValue(values[i], "@name");
            String valueDescription = XpathUtil.getValue(values[i], "description/text()");
            valueName = valueName == null ? "" : valueName.substring(0, 1).toUpperCase() + valueName.substring(1);
            if (valueDescription != null) {
                valueDescription = valueDescription.trim();
            }
            if (valueDescription != null) {
                out.println("  /** " + valueDescription + " */");
            }
            out.println("  public void set" + valueName + "(" + valueTypes[i] + " value) {");
            out.println("    super.set(" + i + ", value);");
            out.println("  }");
            out.println();
            if (valueDescription != null) {
                out.println("  /** " + valueDescription + " */");
            }
            out.println("  public " + valueTypes[i] + " get" + valueName + "() {");
            out.println("    return (" + valueTypes[i] + ") super.get(" + i + ", valueTypeConstructors[" + i + "]);");
            out.println("  }");
            out.println();
        }
        this.printParameters(type, out);
        out.println("}");
        out.flush();
    }
}

