/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.opensocial.gadgets.service.BaseGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.helper.OpenSocialGadgetHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.osgi.framework.Bundle;

@XObject(value="internalGadget")
public class InternalGadgetDescriptor
extends BaseGadgetDescriptor
implements GadgetDeclaration {
    private static final long serialVersionUID = 1L;
    public static final String HTTP = "http://";
    public static final String HTTP_SEPARATOR = ":";
    public static final String URL_SEPARATOR = "/";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@label")
    protected String label;
    @XNode(value="@disabled")
    protected Boolean disabled;
    @XNode(value="entryPoint")
    protected String entryPoint = "";
    @XNode(value="mountPoint")
    protected String mountPoint = "";
    @XNode(value="directory")
    protected String directory = "";
    @XNode(value="category")
    protected String category;
    @XNode(value="description")
    protected String description;
    @XNode(value="icon")
    protected String icon;
    protected Bundle bundle;
    protected ComponentName componentName;

    @Override
    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean getDisabled() {
        if (this.disabled == null) {
            return false;
        }
        return this.disabled;
    }

    public String getIcon() {
        return this.icon;
    }

    public final String getMountPoint() {
        if ("".equals(this.mountPoint)) {
            return this.name;
        }
        return this.mountPoint;
    }

    @Override
    public final String getCategory() {
        return this.category;
    }

    public final void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public final Bundle getBundle() {
        return this.bundle;
    }

    public final void setComponentName(ComponentName name) {
        this.componentName = name;
    }

    public final ComponentName getComponentName() {
        return this.componentName;
    }

    public final void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public final String getEntryPoint() {
        if ("".equals(this.entryPoint)) {
            return this.name + ".xml";
        }
        return this.entryPoint;
    }

    public String getDirectory() {
        if (StringUtils.isBlank((String)this.directory)) {
            return this.name;
        }
        return this.directory;
    }

    @Override
    public String getIconUrl() {
        StringBuilder sb = this.getUrlPrefix(true);
        sb.append(this.getMountPoint());
        sb.append(URL_SEPARATOR);
        sb.append(this.icon);
        return sb.toString();
    }

    public StringBuilder getUrlPrefix(boolean relativeUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append(OpenSocialGadgetHelper.getGadgetsBaseUrl((boolean)relativeUrl, (boolean)false));
        sb.append(Framework.getProperty((String)"opensocial.gadgets.path"));
        return sb;
    }

    @Override
    public InputStream getResourceAsStream(String resourcePath) throws IOException {
        URL gadgetURL = this.getResource(resourcePath);
        if (gadgetURL != null) {
            return gadgetURL.openStream();
        }
        return null;
    }

    @Override
    public URL getResource(String resourcePath) {
        ComponentInstance component = Framework.getRuntime().getComponentInstance(this.componentName);
        Bundle bundle = component.getRuntimeContext().getBundle();
        URL gadgetURL = bundle.getEntry("gadget/" + this.getDirectory() + URL_SEPARATOR + resourcePath);
        if (gadgetURL == null) {
            gadgetURL = bundle.getEntry("gadget/resources/" + resourcePath);
        }
        return gadgetURL;
    }

    @Override
    public URL getGadgetDefinition() {
        try {
            return new URL(this.getGadgetDefinition(false));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getGadgetDefinition(boolean relativeUrl) {
        StringBuilder sb = this.getUrlPrefix(relativeUrl);
        sb.append(this.getMountPoint());
        sb.append(URL_SEPARATOR);
        sb.append(this.getEntryPoint());
        return sb.toString();
    }

    @Override
    public String getPublicGadgetDefinition() {
        return this.getGadgetDefinition(true);
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getDescriptionFromSpec();
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public String getThumbnail() {
        String thumb = super.getThumbnail();
        if (thumb == null || "".equals(thumb.trim())) {
            return this.getIconUrl();
        }
        thumb = this.rewriteURL(thumb);
        return thumb;
    }

    protected String rewriteURL(String url) {
        String loopbackURL;
        if (url != null && url.startsWith(loopbackURL = Framework.getProperty((String)"nuxeo.loopback.url"))) {
            url = url.replaceFirst(loopbackURL, VirtualHostHelper.getContextPathProperty());
        }
        return url;
    }

    @Override
    public String getScreenshot() {
        String screenshot = super.getScreenshot();
        if (screenshot != null) {
            screenshot = this.rewriteURL(screenshot);
        }
        return screenshot;
    }
}

