/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Parser;
import com.google.caja.plugin.Config;
import com.google.caja.plugin.Dom;
import com.google.caja.plugin.FileSystemEnvironment;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginEnvironment;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.SourceSnippetRenderer;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Callback;
import com.google.caja.util.CapturingReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginCompilerMain {
    private final MessageQueue mq;
    private final MessageContext mc;
    private final Map<InputSource, CapturingReader> originalInputs = new HashMap<InputSource, CapturingReader>();
    private final Config config = new Config(this.getClass(), System.err, "Cajoles HTML, CSS, and JS files to JS.");
    private final Callback<IOException> exHandler = new Callback<IOException>(){

        @Override
        public void handle(IOException ex) {
            PluginCompilerMain.this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.toString()));
        }
    };

    private PluginCompilerMain() {
        this.mq = new SimpleMessageQueue();
        this.mc = new MessageContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] argv) {
        if (!this.config.processArguments(argv)) {
            return -1;
        }
        boolean success = false;
        MessageContext mc = null;
        CajoledModule compiledJsOutput = null;
        Node compiledDomOutput = null;
        String compiledHtmlOutput = null;
        try {
            PluginMeta meta = new PluginMeta(this.makeEnvironment(this.config));
            meta.setDebugMode(this.config.debugMode());
            meta.setIdClass(this.config.getIdClass());
            PluginCompiler compiler = new PluginCompiler(BuildInfo.getInstance(), meta, this.mq);
            mc = compiler.getMessageContext();
            compiler.setCssSchema(this.config.getCssSchema(this.mq));
            compiler.setHtmlSchema(this.config.getHtmlSchema(this.mq));
            boolean bl = success = this.parseInputs(this.config.getInputUris(), compiler) && compiler.run();
            if (success) {
                compiledJsOutput = compiler.getJavascript();
                compiledDomOutput = compiler.getStaticHtml();
                String string = compiledHtmlOutput = compiledDomOutput != null ? Nodes.render(compiledDomOutput) : "";
            }
            if (mc == null) {
                mc = new MessageContext();
            }
        }
        catch (Throwable throwable) {
            MessageLevel maxMessageLevel;
            if (mc == null) {
                mc = new MessageContext();
            }
            success &= MessageLevel.ERROR.compareTo(maxMessageLevel = PluginCompilerMain.dumpMessages(this.mq, mc, System.err)) > 0;
            throw throwable;
        }
        MessageLevel maxMessageLevel = PluginCompilerMain.dumpMessages(this.mq, mc, System.err);
        boolean bl = MessageLevel.ERROR.compareTo(maxMessageLevel) > 0;
        if (success &= bl) {
            this.writeFile(this.config.getOutputJsFile(), compiledJsOutput);
            this.writeFile(this.config.getOutputHtmlFile(), compiledHtmlOutput);
        } else {
            this.config.getOutputJsFile().delete();
            this.config.getOutputHtmlFile().delete();
        }
        return success ? 0 : -1;
    }

    private boolean parseInputs(Collection<URI> inputs, PluginCompiler pluginc) {
        boolean parsePassed = true;
        for (URI input : inputs) {
            try {
                ParseTreeNode parseTree = this.parseInput(input);
                if (null == parseTree) continue;
                pluginc.addInput(AncestorChain.instance(parseTree));
            }
            catch (ParseException ex) {
                ex.toMessageQueue(this.mq);
                parsePassed = false;
            }
            catch (IOException ex) {
                this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.toString()));
                parsePassed = false;
            }
        }
        return parsePassed;
    }

    private ParseTreeNode parseInput(URI input) throws IOException, ParseException {
        InputSource is = new InputSource(input);
        this.mc.addInputSource(is);
        CharProducer cp = CharProducer.Factory.create(this.createReader(is, input.toURL().openStream()), is);
        return PluginCompilerMain.parseInput(is, cp, this.mq);
    }

    static ParseTreeNode parseInput(InputSource is, CharProducer cp, MessageQueue mq) throws ParseException {
        AbstractParseTreeNode input;
        String path = is.getUri().getPath();
        if (path.endsWith(".js")) {
            JsLexer lexer = new JsLexer(cp);
            JsTokenQueue tq = new JsTokenQueue(lexer, is);
            if (tq.isEmpty()) {
                return null;
            }
            Parser p = new Parser(tq, mq);
            input = p.parse();
            tq.expectEmpty();
        } else if (path.endsWith(".css")) {
            TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, mq, false);
            if (tq.isEmpty()) {
                return null;
            }
            CssParser p = new CssParser(tq, mq, MessageLevel.WARNING);
            input = p.parseStyleSheet();
            tq.expectEmpty();
        } else if (path.endsWith(".html") || path.endsWith(".xhtml") || !cp.isEmpty() && cp.getBuffer()[cp.getOffset()] == '<') {
            DomParser p = new DomParser(new HtmlLexer(cp), is, mq);
            if (p.getTokenQueue().isEmpty()) {
                return null;
            }
            input = new Dom(p.parseFragment());
            p.getTokenQueue().expectEmpty();
        } else {
            throw new AssertionError((Object)("Can't classify input " + is));
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File outputHtmlFile, String compiledHtmlOutput) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputHtmlFile), "UTF-8");
            try {
                out.append(compiledHtmlOutput);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException ex) {
            this.exHandler.handle(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, CajoledModule module) {
        if (module == null) {
            return;
        }
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            if (this.config.renderer() == Config.SourceRenderMode.DEBUGGER) {
                this.writeFileWithDebug(out, module);
            } else {
                this.writeFileNonDebug(out, module);
            }
        }
        catch (IOException ex) {
            this.exHandler.handle(ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void writeFileNonDebug(Writer out, CajoledModule module) throws IOException {
        TokenConsumer tc;
        switch (this.config.renderer()) {
            case PRETTY: {
                tc = module.makeRenderer(out, this.exHandler);
                break;
            }
            case MINIFY: {
                tc = new JsMinimalPrinter(new Concatenator(out, this.exHandler));
                break;
            }
            case SIDEBYSIDE: {
                tc = new SourceSnippetRenderer(this.buildOriginalInputCharSequences(), this.mc, out, this.exHandler);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized renderer: " + (Object)((Object)this.config.renderer())));
            }
        }
        RenderContext rc = new RenderContext(tc).withAsciiOnly(true).withEmbeddable(true);
        module.render(rc);
        tc.noMoreTokens();
        out.append('\n');
    }

    private void writeFileWithDebug(Writer out, CajoledModule module) throws IOException {
        module.renderWithDebugSymbols(this.buildOriginalInputCharSequences(), out, this.exHandler);
    }

    static MessageLevel dumpMessages(MessageQueue mq, MessageContext mc, Appendable out) {
        MessageLevel maxLevel = MessageLevel.values()[0];
        for (Message m : mq.getMessages()) {
            MessageLevel level = m.getMessageLevel();
            if (maxLevel.compareTo(level) >= 0) continue;
            maxLevel = level;
        }
        MessageLevel ignoreLevel = null;
        if (maxLevel.compareTo(MessageLevel.LINT) < 0) {
            ignoreLevel = MessageLevel.LOG;
        }
        try {
            for (Message m : mq.getMessages()) {
                MessageLevel level = m.getMessageLevel();
                if (ignoreLevel != null && level.compareTo(ignoreLevel) <= 0) continue;
                out.append(level.name() + ": ");
                m.format(mc, out);
                out.append("\n");
                if (maxLevel.compareTo(level) >= 0) continue;
                maxLevel = level;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return maxLevel;
    }

    private PluginEnvironment makeEnvironment(Config config) {
        try {
            return new CachingEnvironment(new File(config.getInputUris().iterator().next()).getParentFile());
        }
        catch (IllegalArgumentException ex) {
            return PluginEnvironment.CLOSED_PLUGIN_ENVIRONMENT;
        }
    }

    private Reader createReader(InputSource is, InputStream stream) {
        InputStreamReader isr;
        try {
            isr = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        if (this.config.renderer() == Config.SourceRenderMode.SIDEBYSIDE || this.config.renderer() == Config.SourceRenderMode.DEBUGGER) {
            CapturingReader cr = new CapturingReader(isr);
            this.originalInputs.put(is, cr);
            return cr;
        }
        return isr;
    }

    private Map<InputSource, CharSequence> buildOriginalInputCharSequences() throws IOException {
        HashMap<InputSource, CharSequence> results = new HashMap<InputSource, CharSequence>();
        for (InputSource is : this.originalInputs.keySet()) {
            results.put(is, this.originalInputs.get(is).getCapture());
        }
        return results;
    }

    public static void main(String[] args) {
        int exitCode;
        try {
            PluginCompilerMain main = new PluginCompilerMain();
            exitCode = main.run(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = -1;
        }
        try {
            System.exit(exitCode);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private class CachingEnvironment
    extends FileSystemEnvironment {
        public CachingEnvironment(File f) {
            super(f);
        }

        protected Reader newReader(File f) throws FileNotFoundException {
            return PluginCompilerMain.this.createReader(new InputSource(f), new FileInputStream(f));
        }
    }
}

