/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.dashboard;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.center.dashboard.AbstractDashboardSpaceCreator;
import org.nuxeo.runtime.api.Framework;

public class AnonymousDashboardSpaceCreator
extends AbstractDashboardSpaceCreator {
    public static final String ANONYMOUS_DASHBOARD_SPACE_NAME = "anonymousDashboardSpace";
    private static final Log log = LogFactory.getLog(AnonymousDashboardSpaceCreator.class);
    public DocumentRef anonymousDashboardSpaceRef;

    public AnonymousDashboardSpaceCreator(CoreSession session, Map<String, String> parameters) {
        super(session, parameters);
    }

    public void run() throws ClientException {
        DocumentModel dashboardManagement = this.getDashboardManagement();
        String anonymousDashboardSpacePath = new Path(dashboardManagement.getPathAsString()).append(ANONYMOUS_DASHBOARD_SPACE_NAME).toString();
        PathRef anonymousDashboardSpacePathRef = new PathRef(anonymousDashboardSpacePath);
        DocumentModel anonymousDashboardSpace = !this.session.exists((DocumentRef)anonymousDashboardSpacePathRef) ? this.createAnonymousDashboardSpace(dashboardManagement.getPathAsString()) : this.session.getDocument((DocumentRef)anonymousDashboardSpacePathRef);
        this.anonymousDashboardSpaceRef = anonymousDashboardSpace.getRef();
    }

    protected DocumentModel createAnonymousDashboardSpace(String dashboardManagementPath) throws ClientException {
        DocumentModel anonymousDashboardSpace = this.session.createDocumentModel(dashboardManagementPath, ANONYMOUS_DASHBOARD_SPACE_NAME, "Space");
        anonymousDashboardSpace.setPropertyValue("dc:title", (Serializable)((Object)"anonymous dashboard space"));
        anonymousDashboardSpace.setPropertyValue("dc:description", (Serializable)((Object)"anonymous dashboard space"));
        anonymousDashboardSpace = this.session.createDocument(anonymousDashboardSpace);
        this.addInitialGadgets(anonymousDashboardSpace);
        this.addAnonymousACP(anonymousDashboardSpace);
        anonymousDashboardSpace = this.session.saveDocument(anonymousDashboardSpace);
        this.session.save();
        return anonymousDashboardSpace;
    }

    protected void addAnonymousACP(DocumentModel anonymousDashboardSpace) throws ClientException {
        ACP acp = anonymousDashboardSpace.getACP();
        ACL acl = acp.getOrCreateACL();
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        acl.add((Object)new ACE(userManager.getAnonymousUserId(), "Read", true));
        anonymousDashboardSpace.setACP(acp, true);
    }
}

