/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.protocol.model.Enum;
import org.apache.shindig.protocol.model.EnumImpl;

public class TestModel {

    public static enum Gender {
        male,
        female;

    }

    public static enum Engine implements Enum.EnumKey
    {
        DIESEL("DIESEL", "Diesel"),
        GAS("GAS", "Gas"),
        HYBRID("HYBRID", "Hybrid"),
        TURBO("TURBO", "Turbo");

        private final String jsonString;
        private final String displayValue;

        private Engine(String jsonString, String displayValue) {
            this.jsonString = jsonString;
            this.displayValue = displayValue;
        }

        public String toString() {
            return this.jsonString;
        }

        @Override
        public String getDisplayValue() {
            return this.displayValue;
        }
    }

    public static class Passenger {
        private String name;
        private Gender gender;

        public Passenger() {
            this.name = "Speed Racer";
            this.gender = Gender.female;
        }

        public Passenger(String name, Gender gender) {
            this.name = name;
            this.gender = gender;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }
    }

    public static class ExpensiveCar
    extends Car {
        private int cost = 100000;

        public int getCost() {
            return this.cost;
        }

        public void setCost(int cost) {
            this.cost = cost;
        }
    }

    public static class Car {
        public static final String DEFAULT_JSON = "{\"engine\":[{\"value\":\"GAS\"},{\"value\":\"HYBRID\"}],\"parkingTickets\":{\"TOKYO\":\"250Y\",\"BERKELEY\":\"$120\"},\"passengers\":[{\"gender\":\"male\",\"name\":\"Dick Dastardly\"},{\"gender\":\"female\",\"name\":\"Speed Racer\"}]}";
        public static final String DEFAULT_XML = "<response><engine><EnumImpl><value><declaringClass>org.apache.shindig.protocol.model.TestModel$Engine</declaringClass><displayValue>Gas</displayValue></value></EnumImpl><EnumImpl><value><declaringClass>org.apache.shindig.protocol.model.TestModel$Engine</declaringClass><displayValue>Hybrid</displayValue></value></EnumImpl></engine><parkingTickets><entry><key>TOKYO</key><value>250Y</value></entry><entry><key>BERKELEY</key><value>$120</value></entry></parkingTickets><passengers><TestModelPassenger><gender><declaringClass>org.apache.shindig.protocol.model.TestModel$Gender</declaringClass></gender><name>Dick Dastardly</name></TestModelPassenger><TestModelPassenger><gender><declaringClass>org.apache.shindig.protocol.model.TestModel$Gender</declaringClass></gender><name>Speed Racer</name></TestModelPassenger></passengers></response>";
        private List<Enum<Engine>> engine;
        private Map<String, String> parkingTickets;
        private List<Passenger> passengers;

        public Car() {
            ArrayList engines = Lists.newArrayList();
            engines.add(new EnumImpl<Engine>(Engine.GAS, null));
            engines.add(new EnumImpl<Engine>(Engine.HYBRID, null));
            this.engine = engines;
            this.parkingTickets = Maps.newHashMap();
            this.parkingTickets.put("BERKELEY", "$120");
            this.parkingTickets.put("TOKYO", "250Y");
            this.passengers = Lists.newArrayList();
            this.passengers.add(new Passenger("Dick Dastardly", Gender.male));
            this.passengers.add(new Passenger("Speed Racer", Gender.female));
        }

        public Car(List<Enum<Engine>> engine, Map<String, String> parkingTickets, List<Passenger> passengers) {
            this.engine = engine;
            this.parkingTickets = parkingTickets;
            this.passengers = passengers;
        }

        public List<Enum<Engine>> getEngine() {
            return this.engine;
        }

        public void setEngine(List<Enum<Engine>> engine) {
            this.engine = engine;
        }

        public Map<String, String> getParkingTickets() {
            return this.parkingTickets;
        }

        public void setParkingTickets(Map<String, String> parkingTickets) {
            this.parkingTickets = parkingTickets;
        }

        public List<Passenger> getPassengers() {
            return this.passengers;
        }

        public void setPassengers(List<Passenger> passengers) {
            this.passengers = passengers;
        }
    }
}

