/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import de.odysseus.el.misc.TypeConverter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.el.ELException;
import org.json.JSONArray;
import org.json.JSONObject;

public class ShindigTypeConverter
implements TypeConverter {
    @Inject
    public ShindigTypeConverter() {
    }

    public <T> T convert(Object obj, Class<T> type) throws ELException {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)this.coerceToBoolean(obj);
        }
        if (type == JSONArray.class) {
            return (T)this.coerceToJsonArray(obj);
        }
        if (type == Iterable.class) {
            return (T)this.coerceToIterable(obj);
        }
        return (T)TypeConverter.DEFAULT.convert(obj, type);
    }

    private Iterable<?> coerceToIterable(Object obj) {
        if (obj == null) {
            return ImmutableList.of();
        }
        if (obj instanceof Iterable) {
            return (Iterable)obj;
        }
        if (obj instanceof JSONArray) {
            final JSONArray array = (JSONArray)obj;
            return new Iterable<Object>(){

                @Override
                public Iterator<Object> iterator() {
                    return new Iterator<Object>(){
                        private int i = 0;

                        @Override
                        public boolean hasNext() {
                            return this.i < array.length();
                        }

                        @Override
                        public Object next() {
                            if (this.i >= array.length()) {
                                throw new NoSuchElementException();
                            }
                            try {
                                return array.get(this.i++);
                            }
                            catch (Exception e) {
                                throw new ELException((Throwable)e);
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }
        if (obj instanceof JSONObject) {
            JSONObject json = (JSONObject)obj;
            Object childList = json.opt("list");
            if (childList != null && childList instanceof JSONArray) {
                return this.coerceToIterable(childList);
            }
            return ImmutableList.of((Object)json);
        }
        return ImmutableList.of((Object)obj);
    }

    private JSONArray coerceToJsonArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JSONArray) {
            return (JSONArray)obj;
        }
        if (obj instanceof String) {
            JSONArray array = new JSONArray();
            StringTokenizer tokenizer = new StringTokenizer(obj.toString(), ",");
            while (tokenizer.hasMoreTokens()) {
                array.put((Object)tokenizer.nextToken());
            }
            return array;
        }
        throw new ELException("Could not coerce " + obj.getClass().getName() + " to JSONArray");
    }

    private Boolean coerceToBoolean(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return !"".equals(obj) && !"false".equals(obj);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return 0 != ((Number)obj).intValue();
        }
        return true;
    }
}

