/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeCache;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.NullCache;
import org.apache.shindig.expressions.Functions;
import org.apache.shindig.expressions.JsonELResolver;
import org.apache.shindig.expressions.ShindigTypeConverter;

@Singleton
public class Expressions {
    private static final String EXPRESSION_CACHE = "expressions";
    private final ExpressionFactory factory;
    private final ELContext parseContext;
    private final ELResolver defaultELResolver;
    private final Functions functions;
    private final TypeConverter typeConverter;

    public static Expressions forTesting() {
        return new Expressions(null, null, new ShindigTypeConverter());
    }

    @Inject
    public Expressions(Functions functions, CacheProvider cacheProvider, ShindigTypeConverter typeConverter) {
        this.functions = functions;
        this.typeConverter = typeConverter;
        this.factory = this.newExpressionFactory(cacheProvider);
        this.parseContext = new Context(null);
        this.defaultELResolver = this.createDefaultELResolver();
    }

    public ELContext newELContext(ELResolver ... customResolvers) {
        CompositeELResolver composite = new CompositeELResolver();
        for (ELResolver customResolver : customResolvers) {
            composite.add(customResolver);
        }
        composite.add(this.defaultELResolver);
        return new Context((ELResolver)composite);
    }

    public ValueExpression parse(String expression, Class<?> type) {
        return this.factory.createValueExpression(this.parseContext, expression, type);
    }

    public ValueExpression constant(Object value, Class<?> type) {
        return this.factory.createValueExpression(value, type);
    }

    private TreeCache createTreeCache(CacheProvider cacheProvider) {
        Cache treeCache = cacheProvider == null ? new NullCache() : cacheProvider.createCache(EXPRESSION_CACHE);
        final Cache resolvedTreeCache = treeCache;
        return new TreeCache(){

            public Tree get(String expression) {
                return (Tree)resolvedTreeCache.getElement(expression);
            }

            public void put(String expression, Tree tree) {
                resolvedTreeCache.addElement(expression, tree);
            }
        };
    }

    private ExpressionFactory newExpressionFactory(CacheProvider cacheProvider) {
        TreeStore store = new TreeStore((TreeBuilder)new Builder(), this.createTreeCache(cacheProvider));
        return new ExpressionFactoryImpl(store, this.typeConverter);
    }

    private ELResolver createDefaultELResolver() {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new JsonELResolver());
        resolver.add((ELResolver)new MapELResolver());
        resolver.add((ELResolver)new ListELResolver());
        resolver.add((ELResolver)new ArrayELResolver());
        return resolver;
    }

    private static class Variables
    extends VariableMapper {
        private final Map<String, ValueExpression> variables = Maps.newHashMap();

        private Variables() {
        }

        public ValueExpression resolveVariable(String var) {
            return this.variables.get(var);
        }

        public ValueExpression setVariable(String var, ValueExpression expression) {
            return this.variables.put(var, expression);
        }
    }

    private class Context
    extends ELContext {
        private final ELResolver resolver;
        private VariableMapper variables;

        public Context(ELResolver resolver) {
            this.resolver = resolver;
        }

        public ELResolver getELResolver() {
            return this.resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return Expressions.this.functions;
        }

        public VariableMapper getVariableMapper() {
            if (this.variables == null) {
                this.variables = new Variables();
            }
            return this.variables;
        }
    }
}

