/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;

public class UrlParameterAuthenticationHandler
implements AuthenticationHandler {
    private static final String TOKEN_PARAM = "st";
    private final SecurityTokenDecoder securityTokenDecoder;

    @Inject
    public UrlParameterAuthenticationHandler(SecurityTokenDecoder securityTokenDecoder) {
        this.securityTokenDecoder = securityTokenDecoder;
    }

    @Override
    public String getName() {
        return AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    }

    @Override
    public SecurityToken getSecurityTokenFromRequest(HttpServletRequest request) throws AuthenticationHandler.InvalidAuthenticationException {
        Map<String, String> parameters = this.getMappedParameters(request);
        try {
            if (parameters.get("token") == null) {
                return null;
            }
            return this.securityTokenDecoder.createToken(parameters);
        }
        catch (SecurityTokenException e) {
            throw new AuthenticationHandler.InvalidAuthenticationException("Malformed security token " + parameters.get("token"), e);
        }
    }

    @Override
    public String getWWWAuthenticateHeader(String realm) {
        return null;
    }

    protected SecurityTokenDecoder getSecurityTokenDecoder() {
        return this.securityTokenDecoder;
    }

    protected Map<String, String> getMappedParameters(HttpServletRequest request) {
        HashMap params = Maps.newHashMap();
        params.put("token", request.getParameter(TOKEN_PARAM));
        params.put("activeUrl", this.getActiveUrl(request));
        return params;
    }

    protected String getActiveUrl(HttpServletRequest request) {
        return request.getRequestURL().toString();
    }
}

