/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.auth;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.AuthenticationMode;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;

public class BlobCrypterSecurityToken
implements SecurityToken {
    protected static final int MAX_TOKEN_LIFETIME_SECS = 3600;
    protected static final String OWNER_KEY = "o";
    protected static final String VIEWER_KEY = "v";
    protected static final String GADGET_KEY = "g";
    protected static final String GADGET_INSTANCE_KEY = "i";
    protected static final String TRUSTED_JSON_KEY = "j";
    protected final BlobCrypter crypter;
    protected final String container;
    protected final String domain;
    protected String ownerId;
    protected String viewerId;
    protected String appUrl;
    protected long moduleId;
    protected String trustedJson;
    protected String activeUrl;

    public BlobCrypterSecurityToken(BlobCrypter crypter, String container, String domain) {
        this.crypter = crypter;
        this.container = container;
        this.domain = domain;
    }

    static BlobCrypterSecurityToken decrypt(BlobCrypter crypter, String container, String domain, String token, String activeUrl) throws BlobCrypterException {
        Map<String, String> values = crypter.unwrap(token, 3600);
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken(crypter, container, domain);
        BlobCrypterSecurityToken.setTokenValues(t, values);
        t.setActiveUrl(activeUrl);
        return t;
    }

    protected static void setTokenValues(BlobCrypterSecurityToken token, Map<String, String> values) {
        token.setOwnerId(values.get(OWNER_KEY));
        token.setViewerId(values.get(VIEWER_KEY));
        token.setAppUrl(values.get(GADGET_KEY));
        String moduleId = values.get(GADGET_INSTANCE_KEY);
        if (moduleId != null) {
            token.setModuleId(Long.parseLong(moduleId));
        }
        token.setTrustedJson(values.get(TRUSTED_JSON_KEY));
    }

    public String encrypt() throws BlobCrypterException {
        Map<String, String> values = this.buildValuesMap();
        return this.container + ':' + this.crypter.wrap(values);
    }

    protected Map<String, String> buildValuesMap() {
        HashMap values = Maps.newHashMap();
        if (this.ownerId != null) {
            values.put(OWNER_KEY, this.ownerId);
        }
        if (this.viewerId != null) {
            values.put(VIEWER_KEY, this.viewerId);
        }
        if (this.appUrl != null) {
            values.put(GADGET_KEY, this.appUrl);
        }
        if (this.moduleId != 0L) {
            values.put(GADGET_INSTANCE_KEY, Long.toString(this.moduleId));
        }
        if (this.trustedJson != null) {
            values.put(TRUSTED_JSON_KEY, this.trustedJson);
        }
        return values;
    }

    @Override
    public String getAppId() {
        return this.appUrl;
    }

    @Override
    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(long moduleId) {
        this.moduleId = moduleId;
    }

    @Override
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @Override
    public String getTrustedJson() {
        return this.trustedJson;
    }

    public void setTrustedJson(String trustedJson) {
        this.trustedJson = trustedJson;
    }

    @Override
    public String getUpdatedToken() {
        return null;
    }

    @Override
    public String getAuthenticationMode() {
        return AuthenticationMode.SECURITY_TOKEN_URL_PARAMETER.name();
    }

    @Override
    public String getViewerId() {
        return this.viewerId;
    }

    public void setViewerId(String viewerId) {
        this.viewerId = viewerId;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    public void setActiveUrl(String activeUrl) {
        this.activeUrl = activeUrl;
    }

    @Override
    public String getActiveUrl() {
        if (this.activeUrl == null) {
            throw new UnsupportedOperationException("No active URL available");
        }
        return this.activeUrl;
    }
}

