/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.gadgets;

import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.rewrite.RequestRewriterRegistry;
import org.apache.shindig.gadgets.servlet.MakeRequestHandler;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.shindig.gadgets.NXFeedProcessor;
import org.nuxeo.runtime.api.Framework;

@Singleton
public class NXMakeRequestHandler
extends MakeRequestHandler {
    private static final Log log = LogFactory.getLog(NXMakeRequestHandler.class);
    public static final String NUXEO_REST = "/nuxeo/restAPI";
    public static final String NUXEO_WEBENG = "/nuxeo/site";
    public static final String COOKIE = "Cookie";
    public static final String JSESSIONCOOKIE = "JSESSIONID=";
    protected OpenSocialService svc;

    @Inject
    public NXMakeRequestHandler(RequestPipeline requestPipeline, RequestRewriterRegistry contentRewriterRegistry) {
        super(requestPipeline, contentRewriterRegistry);
        try {
            this.svc = (OpenSocialService)Framework.getService(OpenSocialService.class);
        }
        catch (Exception e) {
            log.error((Object)"Unable to find opensocial service!", (Throwable)e);
        }
    }

    protected String convertResponseToJson(SecurityToken authToken, HttpServletRequest request, HttpResponse results) throws GadgetException {
        String updatedAuthToken;
        String originalUrl = request.getParameter("url");
        String body = results.getResponseAsString();
        if (body.length() > 0 && "FEED".equals(request.getParameter("contentType"))) {
            body = this.NXprocessFeed(originalUrl, request, body);
        }
        Map resp = FetchResponseUtils.getResponseAsJson((HttpResponse)results, null, (String)body);
        if (authToken != null && (updatedAuthToken = authToken.getUpdatedToken()) != null) {
            resp.put("st", updatedAuthToken);
        }
        return JsonSerializer.serialize(Collections.singletonMap(originalUrl, resp));
    }

    private String NXprocessFeed(String url, HttpServletRequest req, String xml) throws GadgetException {
        boolean getSummaries = Boolean.parseBoolean(this.getParameter(req, "getSummaries", "false"));
        int numEntries = Integer.parseInt(this.getParameter(req, "numEntries", "3"));
        return new NXFeedProcessor().process(url, xml, getSummaries, numEntries).toString();
    }

    protected HttpRequest buildHttpRequest(HttpServletRequest request) throws GadgetException {
        HttpRequest req = super.buildHttpRequest(request);
        if (!this.svc.propagateJSESSIONIDToTrustedHosts()) {
            return req;
        }
        String auth = req.getUri().getAuthority();
        boolean done = false;
        if (auth != null) {
            String path;
            if (auth.indexOf(58) != -1) {
                auth = auth.substring(0, auth.indexOf(58));
            }
            for (String host : this.svc.getTrustedHosts()) {
                if (!host.trim().equalsIgnoreCase(auth.trim())) continue;
                if (!request.isRequestedSessionIdValid() || !request.isRequestedSessionIdFromCookie()) break;
                req.addHeader(COOKIE, JSESSIONCOOKIE + request.getRequestedSessionId());
                done = true;
                break;
            }
            if (!done && ((path = req.getUri().getPath()).startsWith(NUXEO_REST) || path.startsWith(NUXEO_WEBENG))) {
                req.addHeader(COOKIE, JSESSIONCOOKIE + request.getRequestedSessionId());
            }
        }
        return req;
    }
}

