/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.services;

import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.shindig.gadgets.render.OpenSocialI18NGadgetRewriter;
import org.apache.shindig.gadgets.render.RenderingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingGadgetRewriter;
import org.apache.shindig.gadgets.render.SanitizingRequestRewriter;
import org.apache.shindig.gadgets.rewrite.CssRequestRewriter;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.HTMLContentRewriter;
import org.apache.shindig.gadgets.rewrite.PipelineDataGadgetRewriter;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriterFactory;
import org.apache.shindig.gadgets.rewrite.RequestRewriter;
import org.apache.shindig.gadgets.rewrite.TemplateRewriter;
import org.apache.shindig.gadgets.servlet.CajaContentRewriter;
import org.nuxeo.opensocial.shindig.gadgets.rewrite.NXHTMLContentRewriter;
import org.nuxeo.opensocial.shindig.gadgets.rewrite.NXProxyingLinkRewriterFactory;

public class NXRewriteModule
extends AbstractModule {
    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<List<GadgetRewriter>>(){}).toProvider(GadgetRewritersProvider.class);
        this.bind((TypeLiteral)new TypeLiteral<List<RequestRewriter>>(){}).toProvider(RequestRewritersProvider.class);
        this.bind(ProxyingLinkRewriterFactory.class).to(NXProxyingLinkRewriterFactory.class);
    }

    private static class RequestRewritersProvider
    implements Provider<List<RequestRewriter>> {
        private final List<RequestRewriter> rewriters = Lists.newArrayList();

        @Inject
        public RequestRewritersProvider(HTMLContentRewriter optimizingRewriter, CssRequestRewriter cssRewriter, SanitizingRequestRewriter sanitizedRewriter) {
            this.rewriters.add((RequestRewriter)optimizingRewriter);
            this.rewriters.add((RequestRewriter)cssRewriter);
            this.rewriters.add((RequestRewriter)sanitizedRewriter);
        }

        public List<RequestRewriter> get() {
            return this.rewriters;
        }
    }

    private static class GadgetRewritersProvider
    implements Provider<List<GadgetRewriter>> {
        private final List<GadgetRewriter> rewriters = Lists.newArrayList();

        @Inject
        public GadgetRewritersProvider(PipelineDataGadgetRewriter pipelineRewriter, TemplateRewriter templateRewriter, NXHTMLContentRewriter optimizingRewriter, CssRequestRewriter cssRewriter, CajaContentRewriter cajaRewriter, SanitizingGadgetRewriter sanitizedRewriter, RenderingGadgetRewriter renderingRewriter, OpenSocialI18NGadgetRewriter i18nRewriter) {
            this.rewriters.add((GadgetRewriter)pipelineRewriter);
            this.rewriters.add((GadgetRewriter)templateRewriter);
            this.rewriters.add(optimizingRewriter);
            this.rewriters.add((GadgetRewriter)cajaRewriter);
            this.rewriters.add((GadgetRewriter)sanitizedRewriter);
            this.rewriters.add((GadgetRewriter)renderingRewriter);
            this.rewriters.add((GadgetRewriter)i18nRewriter);
        }

        public List<GadgetRewriter> get() {
            return this.rewriters;
        }
    }
}

