/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.Lists;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.spec.MessageBundle;

public class MessageELResolver
extends ELResolver {
    public static final String PROPERTY_MSG = "Msg";
    private final MessageBundle bundle;
    private final Expressions expressions;

    public MessageELResolver(Expressions expressions, MessageBundle bundle) {
        this.expressions = expressions;
        this.bundle = bundle;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null && PROPERTY_MSG.equals(property)) {
            context.setPropertyResolved(true);
            return this.bundle;
        }
        if (base instanceof MessageBundle) {
            String text = this.bundle.getMessages().get(property);
            if (text == null) {
                context.setPropertyResolved(true);
                return null;
            }
            List<Object> properties = null;
            try {
                properties = this.pushCurrentProperty(context, property);
                context.setPropertyResolved(false);
                Object object = this.expressions.parse(text, Object.class).getValue(context);
                return object;
            }
            finally {
                this.popProperty(properties);
                context.setPropertyResolved(true);
            }
        }
        return null;
    }

    private List<Object> pushCurrentProperty(ELContext context, Object property) {
        List propertyList = (List)context.getContext(MessageELResolver.class);
        if (propertyList == null) {
            propertyList = Lists.newArrayList();
            context.putContext(MessageELResolver.class, (Object)propertyList);
        } else if (propertyList.contains(property)) {
            throw new ELException("Recursive invocation of message bundle properties");
        }
        propertyList.add(property);
        return propertyList;
    }

    private void popProperty(List<Object> properties) {
        if (properties != null) {
            properties.remove(properties.size() - 1);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null && PROPERTY_MSG.equals(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && PROPERTY_MSG.equals(property)) {
            throw new PropertyNotWritableException();
        }
    }
}

