/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;

public class BMPOptimizer
extends PNGOptimizer {
    public static BufferedImage readBmp(InputStream is) throws ImageReadException, IOException {
        return Sanselan.getBufferedImage((InputStream)is);
    }

    public BMPOptimizer(OptimizerConfig config, HttpResponse original) {
        super(config, original);
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        this.outputter = new BaseOptimizer.ImageIOOutputter(writer, null);
    }

    @Override
    protected void rewriteImpl(BufferedImage image) throws IOException {
        super.rewriteImpl(image);
    }

    @Override
    protected String getOriginalContentType() {
        return "image/bmp";
    }

    @Override
    protected String getOriginalFormatName() {
        return "bmp";
    }
}

