/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.View;

public class Gadget {
    private FeatureRegistry featureRegistry;
    private GadgetContext context;
    private GadgetSpec spec;
    private Collection<PreloadedData> preloads;
    private View currentView;
    private Set<String> directFeatureDeps;
    private List<String> allGadgetFeatures;

    public Gadget setContext(GadgetContext context) {
        this.context = context;
        return this;
    }

    public GadgetContext getContext() {
        return this.context;
    }

    public Gadget setGadgetFeatureRegistry(FeatureRegistry registry) {
        this.featureRegistry = registry;
        return this;
    }

    public Gadget setSpec(GadgetSpec spec) {
        this.spec = spec;
        this.directFeatureDeps = Sets.newHashSet(spec.getModulePrefs().getFeatures().keySet());
        return this;
    }

    public GadgetSpec getSpec() {
        return this.spec;
    }

    public Gadget setPreloads(Collection<PreloadedData> preloads) {
        this.preloads = preloads;
        return this;
    }

    public Collection<PreloadedData> getPreloads() {
        return this.preloads;
    }

    public synchronized List<String> getAllFeatures() {
        if (this.allGadgetFeatures == null) {
            if (this.featureRegistry != null) {
                this.allGadgetFeatures = this.featureRegistry.getFeatures(Lists.newArrayList(this.directFeatureDeps));
            } else {
                throw new IllegalStateException("setGadgetFeatureRegistry must be called before Gadget.getAllFeatures()");
            }
        }
        return this.allGadgetFeatures;
    }

    public Gadget setCurrentView(View currentView) {
        this.currentView = currentView;
        return this;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public LocaleSpec getLocale() {
        return this.spec.getModulePrefs().getLocale(this.context.getLocale());
    }

    public void addFeature(String name) {
        this.directFeatureDeps.add(name);
    }

    public void removeFeature(String name) {
        this.directFeatureDeps.remove(name);
    }

    public Set<String> getDirectFeatureDeps() {
        return Collections.unmodifiableSet(this.directFeatureDeps);
    }

    public boolean sanitizeOutput() {
        return this.getCurrentView() != null && this.getCurrentView().getType() == View.ContentType.HTML_SANITIZED || "1".equals(this.getContext().getParameter("sanitize"));
    }
}

