/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.SpecParserException;

public abstract class AbstractSpecFactory<T> {
    private static final Logger logger = Logger.getLogger(AbstractSpecFactory.class.getName());
    private final Class<T> clazz;
    private final ExecutorService executor;
    private final RequestPipeline pipeline;
    final SoftExpiringCache<Uri, Object> cache;
    private final long refresh;

    public AbstractSpecFactory(Class<T> clazz, ExecutorService executor, RequestPipeline pipeline, Cache<Uri, Object> cache, long refresh) {
        this.clazz = clazz;
        this.executor = executor;
        this.pipeline = pipeline;
        this.cache = new SoftExpiringCache(cache);
        this.refresh = refresh;
    }

    protected T getSpec(Query query) throws GadgetException {
        SoftExpiringCache.CachedObject cached;
        Object obj = null;
        if (!query.ignoreCache && (cached = this.cache.getElement((Object)query.specUri)) != null) {
            obj = cached.obj;
            if (cached.isExpired) {
                this.cache.addElement((Object)query.specUri, obj, this.refresh);
                this.executor.execute(new SpecUpdater(query, obj));
            }
        }
        if (obj == null) {
            try {
                obj = this.fetchFromNetwork(query);
            }
            catch (GadgetException e) {
                obj = e;
            }
            this.cache.addElement((Object)query.specUri, obj, this.refresh);
        }
        if (obj instanceof GadgetException) {
            throw obj;
        }
        return this.clazz.cast(obj);
    }

    protected T fetchFromNetwork(Query query) throws GadgetException {
        HttpRequest request = new HttpRequest(query.specUri).setIgnoreCache(query.ignoreCache).setGadget(query.gadgetUri).setContainer(query.container);
        request.setCacheTtl((int)(this.refresh / 1000L));
        HttpResponse response = this.pipeline.execute(request);
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve spec for " + query.specUri + ". HTTP error " + response.getHttpStatusCode());
        }
        try {
            String content = response.getResponseAsString();
            return this.parse(content, query);
        }
        catch (XmlException e) {
            throw new SpecParserException(e);
        }
    }

    protected abstract T parse(String var1, Query var2) throws XmlException, GadgetException;

    private class SpecUpdater
    implements Runnable {
        private final Query query;
        private final Object old;

        public SpecUpdater(Query query, Object old) {
            this.query = query;
            this.old = old;
        }

        @Override
        public void run() {
            try {
                Object newSpec = AbstractSpecFactory.this.fetchFromNetwork(this.query);
                AbstractSpecFactory.this.cache.addElement((Object)this.query.specUri, newSpec, AbstractSpecFactory.this.refresh);
            }
            catch (GadgetException e) {
                if (this.old != null) {
                    logger.log(Level.INFO, "Failed to update {0}. Using cached version.", this.query.specUri);
                    AbstractSpecFactory.this.cache.addElement((Object)this.query.specUri, this.old, AbstractSpecFactory.this.refresh);
                }
                logger.log(Level.INFO, "Failed to update {0}. Applying negative cache.", this.query.specUri);
                AbstractSpecFactory.this.cache.addElement((Object)this.query.specUri, (Object)e, AbstractSpecFactory.this.refresh);
            }
        }
    }

    protected static class Query {
        private Uri specUri = null;
        private String container = "default";
        private Uri gadgetUri = null;
        private boolean ignoreCache = false;

        protected Query() {
        }

        public Query setSpecUri(Uri specUri) {
            this.specUri = specUri;
            return this;
        }

        public Query setContainer(String container) {
            this.container = container;
            return this;
        }

        public Query setGadgetUri(Uri gadgetUri) {
            this.gadgetUri = gadgetUri;
            return this;
        }

        public Query setIgnoreCache(boolean ignoreCache) {
            this.ignoreCache = ignoreCache;
            return this;
        }

        public Uri getSpecUri() {
            return this.specUri;
        }

        public String getContainer() {
            return this.container;
        }

        public Uri getGadgetUri() {
            return this.gadgetUri;
        }

        public boolean getIgnoreCache() {
            return this.ignoreCache;
        }
    }
}

