/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="GadgetDocument")
public class GadgetDocument
extends DocumentObject {
    private static final String ENABLE_CACHE_HEADER = "opensocial.features.enableCacheHeader";
    private static final String DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final String GADGET_HTML_CONTENT = "gadget:htmlContent";
    private static final String GADGET_CONTENT_FILES = "gadgetContent";
    private static final String FILES_FILES = "files:files";
    private static final String FILENAME = "filename";
    private static final String FILE = "file";
    private static final String HTML_CONTENT = "htmlContent";
    private static final int DEFAULT_SIZE_WIDTH = 600;
    private ConversionService conversionService = null;
    private static final Log log = LogFactory.getLog(GadgetDocument.class);
    private ImagingService imagingService;

    @GET
    public Object doGet() {
        return Response.serverError();
    }

    @POST
    @Path(value="deletePicture")
    public Response doDelete() {
        try {
            this.doc.setPropertyValue("file:content", null);
            CoreSession session = this.getContext().getCoreSession();
            session.saveDocument(this.doc);
            session.save();
        }
        catch (ClientException e) {
            this.doDeleteFiles(GADGET_CONTENT_FILES);
        }
        return Response.ok((Object)"File upload ok", (String)"text/plain").build();
    }

    @POST
    @Path(value="delete/{filename}")
    public Response doDeleteFiles(@PathParam(value="filename") String filename) {
        try {
            this.removeFile(filename);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
        return Response.ok((Object)"File upload ok", (String)"text/plain").build();
    }

    @POST
    public Response doPost() {
        String schema = null;
        FormData form = this.ctx.getForm();
        form.fillDocument(this.doc);
        if (form.isMultipartContent()) {
            Blob blob = form.getFirstBlob();
            if (blob == null) {
                throw new IllegalArgumentException("Could not find any uploaded file");
            }
            if (!"".equals(blob.getFilename())) {
                try {
                    String resize;
                    String crop = form.getString("crop");
                    if (crop != null) {
                        String[] dim = crop.split("x");
                        blob = this.getCroppedBlob(blob, Integer.parseInt(dim[0]), Integer.parseInt(dim[1]));
                    }
                    if ((resize = form.getString("resize_width")) != null) {
                        int resizeWidth = 600;
                        try {
                            resizeWidth = Integer.parseInt(resize);
                        }
                        catch (NumberFormatException e) {
                            log.info((Object)"No width for resize picture, use default size");
                        }
                        blob = this.getResizedBlobl(blob, resizeWidth);
                    }
                    if ((schema = form.getString("schema")) != null) {
                        String filename = form.getMultiPartFormProperty(FILENAME);
                        if (filename == null) {
                            filename = GADGET_CONTENT_FILES;
                        }
                        this.addFile(blob, filename);
                    }
                    String xpath = "file:content";
                    Property p = this.doc.getProperty(xpath);
                    p.getParent().get(FILENAME).setValue((Object)blob.getFilename());
                    p.setValue((Object)blob);
                }
                catch (Exception e) {
                    throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
                }
            }
        } else {
            Map fields = form.getFormFields();
            for (Map.Entry entry : fields.entrySet()) {
                String[] strings;
                String key = (String)entry.getKey();
                if (!key.startsWith("wcopensocial:files/") || (strings = key.split("/")).length != 2) continue;
                try {
                    String htmlContent = form.getFormProperty(key);
                    String filename = strings[1];
                    Blob file = Blobs.createBlob((String)htmlContent);
                    ArrayList files = (ArrayList)this.doc.getPropertyValue(FILES_FILES);
                    boolean isUpdated = false;
                    for (Map map : files) {
                        if (!map.containsKey(FILENAME) || !filename.equals(map.get(FILENAME))) continue;
                        map.put(FILE, (Serializable)file);
                        isUpdated = true;
                        break;
                    }
                    if (!isUpdated) {
                        HashMap<String, Object> fileMap = new HashMap<String, Object>();
                        fileMap.put(FILE, (Serializable)file);
                        fileMap.put(FILENAME, filename);
                        files.add(fileMap);
                    }
                    this.doc.setPropertyValue(FILES_FILES, (Serializable)files);
                }
                catch (PropertyException e) {
                    throw WebException.wrap((Throwable)e);
                }
                catch (ClientException e) {
                    throw WebException.wrap((Throwable)e);
                }
            }
        }
        if (schema == null) {
            try {
                CoreSession session = this.getContext().getCoreSession();
                session.saveDocument(this.doc);
                session.save();
            }
            catch (ClientException e) {
                throw WebException.wrap((Throwable)e);
            }
        }
        return Response.ok((Object)"File upload ok!", (String)"text/plain").build();
    }

    protected Blob getCroppedBlob(Blob blob, int newWidth, int newHeight) throws IOException, ConversionException, ClientException {
        double ratio;
        String fileName = blob.getFilename();
        HashMap<String, Object> options = new HashMap<String, Object>();
        ImageInfo imageInfo = this.getImagingService().getImageInfo(blob);
        int oldWidth = imageInfo.getWidth();
        int oldHeight = imageInfo.getHeight();
        if (oldWidth < newWidth && oldHeight < newHeight) {
            newWidth = oldWidth;
            newHeight = oldHeight;
        } else if (oldWidth < newWidth && oldHeight > newHeight) {
            ratio = newWidth / newHeight;
            newHeight = (int)Math.round((double)oldWidth / ratio);
            newWidth = oldWidth;
        } else if (oldHeight < newHeight && oldWidth > newWidth) {
            ratio = newWidth / newHeight;
            newWidth = (int)Math.round((double)oldHeight / ratio);
            newHeight = oldHeight;
        }
        blob = this.getImagingService().crop(blob, 0, 0, newWidth, newHeight);
        imageInfo = this.getImagingService().getImageInfo(blob);
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        options.put("width", newWidth);
        options.put("height", newHeight);
        options.put("depth", imageInfo.getDepth());
        options.put("conversionFormat", "jpg");
        bh = this.getConversionService().convert("pictureResize", (BlobHolder)bh, options);
        blob = bh.getBlob() != null ? bh.getBlob() : blob;
        String viewFilename = this.computeViewFilename(fileName, "jpg");
        blob.setFilename(viewFilename);
        return blob;
    }

    protected Blob getResizedBlobl(Blob blob, int newWidth) throws ClientException, IOException {
        String fileName = blob.getFilename();
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        HashMap<String, Object> options = new HashMap<String, Object>();
        try {
            ImageInfo imageInfo = this.getImagingService().getImageInfo(bh.getBlob());
            int width = imageInfo.getWidth();
            int height = imageInfo.getHeight();
            int depth = imageInfo.getDepth();
            double ratio = 1.0 * (double)newWidth / (double)width;
            int newHeight = (int)Math.round((double)height * ratio);
            options.put("height", newHeight);
            options.put("depth", depth);
        }
        catch (Exception e) {
            // empty catch block
        }
        options.put("width", newWidth);
        options.put("conversionFormat", "jpg");
        bh = this.getConversionService().convert("pictureResize", (BlobHolder)bh, options);
        blob = bh.getBlob() != null ? bh.getBlob() : blob;
        String viewFilename = this.computeViewFilename(fileName, "jpg");
        blob.setFilename(viewFilename);
        return blob;
    }

    protected ConversionService getConversionService() throws ClientException {
        if (this.conversionService == null) {
            try {
                this.conversionService = (ConversionService)Framework.getService(ConversionService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return this.conversionService;
    }

    protected ImagingService getImagingService() {
        if (this.imagingService == null) {
            try {
                this.imagingService = (ImagingService)Framework.getService(ImagingService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.imagingService;
    }

    @GET
    @Path(value="hasFile")
    public Response hasFile() {
        try {
            ArrayList<Map<String, Serializable>> files = this.getFilesStoredInGadget();
            for (Map<String, Serializable> map : files) {
                if (map.get(FILE) == null || map.get(FILENAME) == null) continue;
                return Response.ok((Object)"true").build();
            }
            this.getBlobFromDoc(this.doc);
        }
        catch (Exception e) {
            throw new WebApplicationException(404);
        }
        return Response.ok((Object)"true").build();
    }

    @GET
    @Path(value="file")
    public Object getFile(@Context Request request) {
        try {
            Blob blob = this.getBlobFromDoc(this.doc);
            return this.buildResponseToGetFile(request, blob);
        }
        catch (ClientException e1) {
            try {
                Blob blob = this.getFileWithSpecificName(GADGET_CONTENT_FILES);
                return this.buildResponseToGetFile(request, blob);
            }
            catch (ClientException e) {
                throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
            }
        }
    }

    @GET
    @Path(value="file/{filename}")
    public Object getFile(@Context Request request, @PathParam(value="filename") String filename) {
        try {
            Blob blob = this.getFileWithSpecificName(filename);
            return this.buildResponseToGetFile(request, blob);
        }
        catch (ClientException e) {
            throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
        }
    }

    private Response buildResponseToGetFile(Request request, Blob blob) throws PropertyException, ClientException {
        Response.ResponseBuilder rb;
        EntityTag tag = GadgetDocument.getEntityTagForDocument(this.doc);
        Calendar modified = (Calendar)this.doc.getPropertyValue("dc:modified");
        if (this.isCacheHeaderEnabled() && (rb = request.evaluatePreconditions(modified.getTime(), tag)) != null) {
            return rb.build();
        }
        String filename = blob.getFilename();
        String contentDisposition = "attachment;filename=" + filename;
        if (filename.endsWith(".swf")) {
            contentDisposition = "inline;";
        }
        Response.ResponseBuilder rb2 = Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType());
        if (this.isCacheHeaderEnabled()) {
            rb2 = rb2.lastModified(modified.getTime()).expires(modified.getTime()).tag(tag);
        }
        return rb2.build();
    }

    private boolean isCacheHeaderEnabled() {
        String property = Framework.getProperty((String)ENABLE_CACHE_HEADER);
        return property != null && "true".equals(property);
    }

    static EntityTag getEntityTagForDocument(DocumentModel doc) {
        Calendar modified;
        try {
            modified = (Calendar)doc.getPropertyValue("dc:modified");
        }
        catch (ClientException e) {
            modified = Calendar.getInstance();
        }
        return new EntityTag(GadgetDocument.computeDigest(doc.getId() + " " + new SimpleDateFormat(DATEFORMAT).format(modified.getTime())));
    }

    private static String computeDigest(String content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] digest = md.digest(content.getBytes());
            BigInteger bi = new BigInteger(digest);
            return bi.toString(16);
        }
        catch (Exception e) {
            return "";
        }
    }

    private Blob getBlobFromDoc(DocumentModel doc) throws ClientException {
        String xpath = "file:content";
        Property p = doc.getProperty(xpath);
        Blob blob = (Blob)p.getValue();
        if (blob == null) {
            throw new WebResourceNotFoundException("No attached file at " + xpath);
        }
        String fileName = blob.getFilename();
        if (fileName == null) {
            if ((p = p.getParent()).isComplex()) {
                try {
                    fileName = (String)((Object)p.getValue(FILENAME));
                }
                catch (PropertyException e) {
                    fileName = "Unknown";
                }
            }
            blob.setFilename(fileName);
        }
        return blob;
    }

    @GET
    @Path(value="html")
    public Object doGetHtml(@Context Request request) throws PropertyException, ClientException, IOException {
        EntityTag tag = GadgetDocument.getEntityTagForDocument(this.doc);
        Response.ResponseBuilder rb = request.evaluatePreconditions(tag);
        if (rb != null) {
            return rb.build();
        }
        Blob htmlContentBlob = this.getFileWithSpecificName(HTML_CONTENT);
        if (htmlContentBlob != null) {
            return Response.ok((Object)htmlContentBlob.getString(), (String)"text/html").build();
        }
        String htmlContent = (String)((Object)this.doc.getPropertyValue(GADGET_HTML_CONTENT));
        return Response.ok((Object)htmlContent, (String)"text/html").build();
    }

    protected String computeViewFilename(String filename, String format) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return filename + "." + format;
        }
        return filename.substring(0, index + 1) + format;
    }

    protected Blob getFileWithSpecificName(String filename) throws PropertyException, ClientException {
        ArrayList<Map<String, Serializable>> files = this.getFilesStoredInGadget();
        for (Map<String, Serializable> map : files) {
            if (!map.containsValue(filename) || map.get(FILE) == null) continue;
            Blob htmlContentBlob = (Blob)map.get(FILE);
            return htmlContentBlob;
        }
        return null;
    }

    protected ArrayList<Map<String, Serializable>> getFilesStoredInGadget() throws PropertyException, ClientException {
        return (ArrayList)this.doc.getPropertyValue(FILES_FILES);
    }

    public void addFile(Blob file, String filename) throws ClientException {
        try {
            ArrayList<Map<String, Serializable>> files = this.getFilesStoredInGadget();
            boolean isUpdate = false;
            for (Map<String, Serializable> map : files) {
                if (!map.containsKey(FILENAME) || !filename.equals(map.get(FILENAME))) continue;
                map.put(FILE, (Serializable)file);
                isUpdate = true;
                break;
            }
            if (!isUpdate) {
                HashMap<String, Object> fileMap = new HashMap<String, Object>();
                fileMap.put(FILE, (Serializable)file);
                fileMap.put(FILENAME, filename);
                files.add(fileMap);
            }
            this.doc.setPropertyValue(FILES_FILES, files);
            CoreSession session = this.doc.getCoreSession();
            session.saveDocument(this.doc);
            session.save();
        }
        catch (PropertyException e) {
            log.error((Object)("No Property files:files for " + this.doc.getType()));
        }
    }

    public void removeFile(String filename) throws ClientException {
        this.addFile(null, filename);
    }
}

