/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.factories;

import java.io.IOException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.importer.factories.AbstractDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class FileManagerDocumentModelFactory
extends AbstractDocumentModelFactory {
    protected FileManager fileManager;

    @Override
    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        FileManager fileManager = this.getFileManager();
        return fileManager.createFolder(session, node.getName(), parent.getPathAsString());
    }

    @Override
    public DocumentModel createLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        FileManager fileManager = this.getFileManager();
        BlobHolder bh = node.getBlobHolder();
        DocumentModel doc = fileManager.createDocumentFromBlob(session, bh.getBlob(), parent.getPathAsString(), true, node.getName());
        doc = this.setDocumentProperties(session, bh.getProperties(), doc);
        return doc;
    }

    protected FileManager getFileManager() {
        if (this.fileManager == null) {
            this.fileManager = (FileManager)Framework.getService(FileManager.class);
        }
        return this.fileManager;
    }
}

