/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.workmanager;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.lib.core.mqueues.computation.AbstractComputation;
import org.nuxeo.lib.core.mqueues.computation.ComputationContext;
import org.nuxeo.lib.core.mqueues.computation.Record;
import org.nuxeo.runtime.metrics.MetricsService;

public class ComputationWork
extends AbstractComputation {
    protected final Timer workTimer;

    public ComputationWork(String name) {
        super(name, 1, 0);
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.workTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", name, "total"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRecord(ComputationContext context, String inputStreamName, Record record) {
        Work work = ComputationWork.deserialize(record.data);
        try {
            work.run();
        }
        finally {
            work.cleanUp(true, null);
            this.workTimer.update(work.getCompletionTime() - work.getStartTime(), TimeUnit.MILLISECONDS);
        }
        context.askForCheckpoint();
    }

    public static Work deserialize(byte[] data) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(bis);
            Work work = (Work)in.readObject();
            return work;
        }
        catch (IOException | ClassNotFoundException e) {
            System.out.println("Error " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Work work) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(work);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            System.out.println("Error " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

