/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.producer;

import java.util.Collections;
import org.nuxeo.ecm.platform.mqueues.importer.message.BlobInfoMessage;
import org.nuxeo.ecm.platform.mqueues.importer.message.DocumentMessage;
import org.nuxeo.ecm.platform.mqueues.importer.producer.RandomDocumentMessageProducer;
import org.nuxeo.ecm.platform.mqueues.importer.producer.RandomMQBlobInfoFetcher;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQTailer;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerIterator;

public class RandomDocumentMessageProducerFactory
implements ProducerFactory<DocumentMessage> {
    protected final long nbDocuments;
    protected final String lang;
    protected final int blobSizeKb;
    protected final MQManager manager;
    protected final String mqName;

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, int blobSizeKb) {
        this.nbDocuments = nbDocuments;
        this.lang = lang;
        this.manager = null;
        this.blobSizeKb = blobSizeKb;
        this.mqName = null;
    }

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, MQManager manager, String mqBlobInfoName) {
        this.nbDocuments = nbDocuments;
        this.lang = lang;
        this.manager = manager;
        this.mqName = mqBlobInfoName;
        this.blobSizeKb = 0;
    }

    public ProducerIterator<DocumentMessage> createProducer(int producerId) {
        RandomMQBlobInfoFetcher fetcher = null;
        if (this.manager != null) {
            MQTailer tailer = this.manager.createTailer(this.getGroupName(producerId), Collections.singleton(MQPartition.of((String)this.mqName, (int)0)));
            fetcher = new RandomMQBlobInfoFetcher((MQTailer<BlobInfoMessage>)tailer);
        }
        return new RandomDocumentMessageProducer(producerId, this.nbDocuments, this.lang, fetcher).withBlob(this.blobSizeKb, false);
    }

    protected String getGroupName(int producerId) {
        return "RandomDocumentMessageProducer." + producerId;
    }
}

