/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.producer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.mqueues.importer.message.BlobMessage;
import org.nuxeo.lib.core.mqueues.pattern.producer.AbstractProducer;

public class FileBlobMessageProducer
extends AbstractProducer<BlobMessage> {
    private static final Log log = LogFactory.getLog(FileBlobMessageProducer.class);
    protected final File listFile;
    protected int count = 0;
    protected Iterator<String> fileIterator;

    public FileBlobMessageProducer(int producerId, File listFile) {
        super(producerId);
        this.listFile = listFile;
        log.info((Object)("Producer using file list: " + listFile.getAbsolutePath()));
        try {
            this.fileIterator = Files.lines(listFile.toPath()).iterator();
        }
        catch (IOException e) {
            String msg = "Failed to read file: " + listFile.getAbsolutePath();
            log.error((Object)msg, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public int getPartition(BlobMessage message, int partitions) {
        return this.count % partitions;
    }

    public void close() throws Exception {
        super.close();
        this.fileIterator = null;
    }

    public boolean hasNext() {
        return this.fileIterator.hasNext();
    }

    public BlobMessage next() {
        String filePath = this.fileIterator.next();
        ++this.count;
        return new BlobMessage.FileMessageBuilder(filePath).build();
    }
}

