/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.message;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.lib.core.mqueues.pattern.Message;

public class DocumentMessage
implements Message {
    static final long serialVersionUID = 20170529L;
    protected String type;
    protected String parentPath;
    protected String name;
    protected Map<String, Serializable> properties;
    protected Blob blob;
    protected BlobInfo blobInfo;

    public DocumentMessage() {
    }

    protected DocumentMessage(Builder builder) {
        this.type = builder.type;
        this.parentPath = builder.parentPath;
        this.name = builder.name;
        this.properties = builder.properties;
        this.blob = builder.blob;
        this.blobInfo = builder.blobInfo;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.parentPath + "/" + this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public Map<String, Serializable> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Blob getBlob() {
        return this.blob;
    }

    public BlobInfo getBlobInfo() {
        return this.blobInfo;
    }

    public static Builder builder(String type, String parentPath, String name) {
        return new Builder(type, parentPath, name);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.type);
        out.writeObject(this.parentPath);
        out.writeObject(this.name);
        int nbProperties = this.properties == null ? 0 : this.properties.size();
        out.writeInt(nbProperties);
        if (this.properties != null) {
            for (Map.Entry<String, Serializable> entry : this.properties.entrySet()) {
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
            }
        }
        if (this.blob != null) {
            out.writeBoolean(true);
            out.writeObject(this.blob);
        } else {
            out.writeBoolean(false);
        }
        if (this.blobInfo != null) {
            out.writeBoolean(true);
            out.writeObject(this.blobInfo.key);
            out.writeObject(this.blobInfo.digest);
            out.writeLong(this.blobInfo.length);
            out.writeObject(this.blobInfo.filename);
            out.writeObject(this.blobInfo.encoding);
            out.writeObject(this.blobInfo.mimeType);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (String)in.readObject();
        this.parentPath = (String)in.readObject();
        this.name = (String)in.readObject();
        int nbProperties = in.readInt();
        if (nbProperties > 0) {
            this.properties = new HashMap<String, Serializable>(nbProperties);
            while (nbProperties > 0) {
                String key = (String)in.readObject();
                Serializable value = (Serializable)in.readObject();
                this.properties.put(key, value);
                --nbProperties;
            }
        }
        if (in.readBoolean()) {
            this.blob = (Blob)in.readObject();
        }
        if (in.readBoolean()) {
            this.blobInfo = new BlobInfo();
            this.blobInfo.key = (String)in.readObject();
            this.blobInfo.digest = (String)in.readObject();
            this.blobInfo.length = in.readLong();
            this.blobInfo.filename = (String)in.readObject();
            this.blobInfo.encoding = (String)in.readObject();
            this.blobInfo.mimeType = (String)in.readObject();
        }
    }

    public String toString() {
        String bi = "";
        if (this.blobInfo != null) {
            bi = String.format("blobInfo(key=%s filename=%s)", this.blobInfo.key, this.blobInfo.filename);
        } else if (this.blob != null) {
            bi = String.format("blob(filename=%s)", this.blob.getFilename());
        }
        return String.format("DocumentMessage(type=%s name=%s parentPath=%s bi=%s)", this.type, this.name, this.parentPath, bi);
    }

    public static class Builder {
        protected final String name;
        protected final String parentPath;
        protected final String type;
        protected Map<String, Serializable> properties;
        protected Blob blob;
        protected BlobInfo blobInfo;

        protected Builder(String type, String parentPath, String name) {
            this.type = type;
            this.parentPath = parentPath;
            this.name = name;
        }

        public Builder setProperties(HashMap<String, Serializable> properties) {
            this.properties = (Map)properties.clone();
            return this;
        }

        public Builder setBlob(Blob blob) {
            this.blob = blob;
            return this;
        }

        public Builder setBlobInfo(BlobInfo blobInfo) {
            this.blobInfo = new BlobInfo(blobInfo);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public String getParentPath() {
            return this.parentPath;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Serializable> getProperties() {
            return this.properties;
        }

        public DocumentMessage build() {
            return new DocumentMessage(this);
        }
    }
}

