/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.consumer;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.SimpleManagedBlob;
import org.nuxeo.ecm.platform.mqueues.importer.message.DocumentMessage;
import org.nuxeo.lib.core.mqueues.pattern.consumer.AbstractConsumer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DocumentMessageConsumer
extends AbstractConsumer<DocumentMessage> {
    private static final Log log = LogFactory.getLog(DocumentMessageConsumer.class);
    protected final String rootPath;
    protected final String repositoryName;
    protected CoreSession session;

    public DocumentMessageConsumer(String consumerId, String repositoryName, String rootPath) {
        super(consumerId);
        this.rootPath = rootPath;
        this.repositoryName = repositoryName;
    }

    public void close() throws Exception {
        super.close();
        if (this.session != null) {
            this.session.close();
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public void begin() {
        TransactionHelper.startTransaction();
        if (this.session == null) {
            this.session = CoreInstance.openCoreSessionSystem((String)this.repositoryName);
        }
    }

    public void accept(DocumentMessage message) {
        Map<String, Serializable> props;
        DocumentModel doc = this.session.createDocumentModel(this.rootPath + message.getParentPath(), message.getName(), message.getType());
        doc.putContextData("skipDestinationCheck", (Serializable)Boolean.valueOf(true));
        Blob blob = this.getBlob(message);
        if (blob != null) {
            doc.setProperty("file", "content", (Object)blob);
        }
        if ((props = message.getProperties()) != null && !props.isEmpty()) {
            this.setDocumentProperties(doc, props);
        }
        doc = this.session.createDocument(doc);
    }

    protected Blob getBlob(DocumentMessage message) {
        Blob blob = null;
        if (message.getBlob() != null) {
            blob = message.getBlob();
        } else if (message.getBlobInfo() != null) {
            BlobInfo blobInfo = message.getBlobInfo();
            blob = new SimpleManagedBlob(blobInfo);
        }
        return blob;
    }

    public void commit() {
        log.debug((Object)"commit");
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
    }

    public void rollback() {
        log.info((Object)"rollback");
        TransactionHelper.setTransactionRollbackOnly();
        TransactionHelper.commitOrRollbackTransaction();
    }

    protected void setDocumentProperties(DocumentModel doc, Map<String, Serializable> properties) {
        for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
            try {
                doc.setPropertyValue(entry.getKey(), entry.getValue());
            }
            catch (PropertyNotFoundException e) {
                String message = String.format("Property '%s' not found on document type: %s. Skipping it.", entry.getKey(), doc.getType());
                log.error((Object)message, (Throwable)e);
            }
        }
    }
}

