/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.consumer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.platform.mqueues.importer.consumer.DocumentConsumerPolicy;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.pattern.Message;
import org.nuxeo.lib.core.mqueues.pattern.consumer.ConsumerFactory;
import org.nuxeo.lib.core.mqueues.pattern.consumer.ConsumerPolicy;
import org.nuxeo.lib.core.mqueues.pattern.consumer.ConsumerPool;
import org.nuxeo.runtime.api.Framework;

public class DocumentConsumerPool<M extends Message>
extends ConsumerPool<M> {
    private static final Log log = LogFactory.getLog(DocumentConsumerPool.class);
    protected static final String NOTIF_LISTENER = "notificationListener";
    protected static final String MIME_LISTENER = "mimetypeIconUpdater";
    protected static final String INDEXING_LISTENER = "elasticSearchInlineListener";
    protected static final String DUBLICORE_LISTENER = "dclistener";
    protected static final String TPL_LISTENER = "templateCreator";
    protected static final String BINARY_LISTENER = "binaryMetadataSyncListener";
    protected static final String UID_LISTENER = "uidlistener";
    protected boolean blockAsync;
    protected final DocumentConsumerPolicy policy;
    protected boolean blockPostCommit;
    protected boolean bulkMode;
    protected boolean listenerIndexingEnabled;
    protected boolean listenerNotifEnabled;
    protected boolean listenerMimeEnabled;
    protected boolean listenerDublincoreEnabled;
    protected boolean listenerTplEnabled;
    protected boolean listenerBinaryEnabled;
    protected boolean listenerUidEnabled;

    public DocumentConsumerPool(String mqName, MQManager manager, ConsumerFactory<M> factory, ConsumerPolicy consumerPolicy) {
        super(mqName, manager, factory, consumerPolicy);
        EventServiceAdmin eventAdmin = (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
        this.policy = (DocumentConsumerPolicy)consumerPolicy;
        if (eventAdmin == null) {
            log.info((Object)"Can not apply document policy there is no event service available");
            return;
        }
        if (this.policy.blockAsyncListeners()) {
            this.blockAsync = eventAdmin.isBlockAsyncHandlers();
            eventAdmin.setBlockAsyncHandlers(true);
            log.debug((Object)"Block asynchronous listeners");
        }
        if (this.policy.blockPostCommitListeners()) {
            this.blockPostCommit = eventAdmin.isBlockSyncPostCommitHandlers();
            eventAdmin.setBlockSyncPostCommitHandlers(true);
            log.debug((Object)"Block post commit listeners");
        }
        if (this.policy.bulkMode()) {
            this.bulkMode = eventAdmin.isBulkModeEnabled();
            eventAdmin.setBulkModeEnabled(true);
            log.debug((Object)"Enable bulk mode");
        }
        if (this.policy.blockIndexing()) {
            this.listenerIndexingEnabled = this.disableSyncListener(eventAdmin, INDEXING_LISTENER);
            log.debug((Object)"Block ES indexing");
        }
        if (this.policy.blockDefaultSyncListeners()) {
            this.listenerNotifEnabled = this.disableSyncListener(eventAdmin, NOTIF_LISTENER);
            this.listenerMimeEnabled = this.disableSyncListener(eventAdmin, MIME_LISTENER);
            this.listenerDublincoreEnabled = this.disableSyncListener(eventAdmin, DUBLICORE_LISTENER);
            this.listenerTplEnabled = this.disableSyncListener(eventAdmin, TPL_LISTENER);
            this.listenerBinaryEnabled = this.disableSyncListener(eventAdmin, BINARY_LISTENER);
            this.listenerUidEnabled = this.disableSyncListener(eventAdmin, UID_LISTENER);
            log.debug((Object)"Block some default synchronous listener");
        }
    }

    protected boolean disableSyncListener(EventServiceAdmin eventAdmin, String name) {
        EventListenerDescriptor desc = eventAdmin.getListenerList().getDescriptor(name);
        if (desc != null && desc.isEnabled()) {
            eventAdmin.setListenerEnabledFlag(name, false);
            return true;
        }
        return false;
    }

    public void close() throws Exception {
        super.close();
        EventServiceAdmin eventAdmin = (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
        if (eventAdmin == null) {
            return;
        }
        if (this.policy.blockAsyncListeners()) {
            eventAdmin.setBlockAsyncHandlers(this.blockAsync);
            log.debug((Object)("Restore asynchronous listeners blocking state: " + this.blockAsync));
        }
        if (this.policy.blockPostCommitListeners()) {
            eventAdmin.setBlockSyncPostCommitHandlers(this.blockPostCommit);
            log.debug((Object)("Restore post commit listeners blocking state: " + this.blockPostCommit));
        }
        if (this.policy.bulkMode()) {
            eventAdmin.setBulkModeEnabled(this.bulkMode);
            log.debug((Object)("Restore bulk mode: " + this.bulkMode));
        }
        if (this.policy.blockIndexing() && this.listenerIndexingEnabled) {
            eventAdmin.setListenerEnabledFlag(INDEXING_LISTENER, true);
            log.debug((Object)"Unblock ES indexing");
        }
        if (this.policy.blockDefaultSyncListeners()) {
            if (this.listenerNotifEnabled) {
                eventAdmin.setListenerEnabledFlag(NOTIF_LISTENER, true);
            }
            if (this.listenerMimeEnabled) {
                eventAdmin.setListenerEnabledFlag(MIME_LISTENER, true);
            }
            if (this.listenerDublincoreEnabled) {
                eventAdmin.setListenerEnabledFlag(DUBLICORE_LISTENER, true);
            }
            if (this.listenerTplEnabled) {
                eventAdmin.setListenerEnabledFlag(TPL_LISTENER, true);
            }
            if (this.listenerBinaryEnabled) {
                eventAdmin.setListenerEnabledFlag(BINARY_LISTENER, true);
            }
            if (this.listenerUidEnabled) {
                eventAdmin.setListenerEnabledFlag(UID_LISTENER, true);
            }
            log.debug((Object)"Unblock some default synchronous listener");
        }
    }
}

