/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.automation;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.platform.mqueues.MQService;
import org.nuxeo.ecm.platform.mqueues.importer.automation.RandomBlobProducers;
import org.nuxeo.ecm.platform.mqueues.importer.producer.RandomDocumentMessageProducerFactory;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQRebalanceListener;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerPool;
import org.nuxeo.runtime.api.Framework;

@Operation(id="MQImporter.runRandomDocumentProducers", category="Services", label="Produces random blobs", since="9.1", description="Produces random blobs in a mqueues.")
public class RandomDocumentProducers
implements MQRebalanceListener {
    private static final Log log = LogFactory.getLog(RandomDocumentProducers.class);
    public static final String ID = "MQImporter.runRandomDocumentProducers";
    public static final String DEFAULT_MQ_NAME = "mq-doc";
    @Context
    protected OperationContext ctx;
    @Param(name="nbDocuments")
    protected Integer nbDocuments;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads = 8;
    @Param(name="avgBlobSizeKB", required=false)
    protected Integer avgBlobSizeKB = 1;
    @Param(name="lang", required=false)
    protected String lang = "en_US";
    @Param(name="mqName", required=false)
    protected String mqName;
    @Param(name="mqSize", required=false)
    protected Integer mqSize;
    @Param(name="mqBlobInfo", required=false)
    protected String mqBlobInfoName;
    @Param(name="mqConfig", required=false)
    protected String mqConfig;

    @OperationMethod
    public void run() {
        RandomBlobProducers.checkAccess(this.ctx);
        MQService service = (MQService)Framework.getService(MQService.class);
        MQManager manager = service.getManager(this.getMQConfig());
        try {
            manager.createIfNotExists(this.getMQName(), this.getMQSize());
            ProducerPool producers = this.mqBlobInfoName != null ? new ProducerPool(this.getMQName(), manager, (ProducerFactory)new RandomDocumentMessageProducerFactory(this.nbDocuments.intValue(), this.lang, manager, this.mqBlobInfoName), this.nbThreads.shortValue()) : new ProducerPool(this.getMQName(), manager, (ProducerFactory)new RandomDocumentMessageProducerFactory(this.nbDocuments.intValue(), this.lang, this.avgBlobSizeKB), this.nbThreads.shortValue());
            producers.start().get();
            producers.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected int getMQSize() {
        if (this.mqSize != null && this.mqSize > 0) {
            return this.mqSize;
        }
        return this.nbThreads;
    }

    protected String getMQName() {
        if (this.mqName != null) {
            return this.mqName;
        }
        return DEFAULT_MQ_NAME;
    }

    public void onPartitionsRevoked(Collection<MQPartition> partitions) {
    }

    public void onPartitionsAssigned(Collection<MQPartition> partitions) {
    }

    protected String getMQConfig() {
        if (this.mqConfig != null) {
            return this.mqConfig;
        }
        return "import";
    }
}

