/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mqueues.importer.automation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.mqueues.MQService;
import org.nuxeo.ecm.platform.mqueues.importer.producer.RandomStringBlobMessageProducerFactory;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerPool;
import org.nuxeo.runtime.api.Framework;

@Operation(id="MQImporter.runRandomBlobProducers", category="Services", label="Produces random blobs", since="9.1", description="Produces random blobs in a mqueues.")
public class RandomBlobProducers {
    private static final Log log = LogFactory.getLog(RandomBlobProducers.class);
    public static final String ID = "MQImporter.runRandomBlobProducers";
    public static final String DEFAULT_MQ_NAME = "mq-blob";
    @Context
    protected OperationContext ctx;
    @Param(name="nbBlobs")
    protected Integer nbBlobs;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads = 8;
    @Param(name="avgBlobSizeKB", required=false)
    protected Integer avgBlobSizeKB = 1;
    @Param(name="lang", required=false)
    protected String lang = "en_US";
    @Param(name="mqName", required=false)
    protected String mqName;
    @Param(name="mqSize", required=false)
    protected Integer mqSize;
    @Param(name="mqConfig", required=false)
    protected String mqConfig;
    @Param(name="blobMarker", required=false)
    protected String blobMarker;

    @OperationMethod
    public void run() {
        RandomBlobProducers.checkAccess(this.ctx);
        MQService service = (MQService)Framework.getService(MQService.class);
        MQManager manager = service.getManager(this.getMQConfig());
        try {
            manager.createIfNotExists(this.getMQName(), this.getMQSize());
            try (ProducerPool producers = new ProducerPool(this.getMQName(), manager, (ProducerFactory)new RandomStringBlobMessageProducerFactory(this.nbBlobs.intValue(), this.lang, this.avgBlobSizeKB, this.blobMarker), this.nbThreads.shortValue());){
                producers.start().get();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected String getMQName() {
        if (this.mqName != null) {
            return this.mqName;
        }
        return DEFAULT_MQ_NAME;
    }

    protected int getMQSize() {
        if (this.mqSize != null && this.mqSize > 0) {
            return this.mqSize;
        }
        return this.nbThreads;
    }

    protected static void checkAccess(OperationContext context) {
        NuxeoPrincipal principal = (NuxeoPrincipal)context.getPrincipal();
        if (principal == null || !principal.isAdministrator()) {
            throw new RuntimeException("Unauthorized access: " + principal);
        }
    }

    protected String getMQConfig() {
        if (this.mqConfig != null) {
            return this.mqConfig;
        }
        return "import";
    }
}

