/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.pattern.producer;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.pattern.Message;
import org.nuxeo.lib.core.mqueues.pattern.consumer.internals.AbstractCallablePool;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.lib.core.mqueues.pattern.producer.ProducerStatus;
import org.nuxeo.lib.core.mqueues.pattern.producer.internals.ProducerRunner;

public class ProducerPool<M extends Message>
extends AbstractCallablePool<ProducerStatus> {
    private static final Log log = LogFactory.getLog(ProducerPool.class);
    protected final MQManager manager;
    protected final ProducerFactory<M> factory;
    protected final String mqName;

    public ProducerPool(String mqName, MQManager manager, ProducerFactory<M> factory, short nbThreads) {
        super(nbThreads);
        this.mqName = mqName;
        this.manager = manager;
        this.factory = factory;
    }

    @Override
    protected ProducerStatus getErrorStatus() {
        return new ProducerStatus(0, 0L, 0L, 0L, true);
    }

    @Override
    protected Callable<ProducerStatus> getCallable(int i) {
        return new ProducerRunner<M>(this.factory, this.manager.getAppender(this.mqName), i);
    }

    @Override
    protected String getThreadPrefix() {
        return "Nuxeo-Producer";
    }

    @Override
    protected void afterCall(List<ProducerStatus> ret) {
        ret.forEach(arg_0 -> ((Log)log).info(arg_0));
        log.warn((Object)ProducerStatus.toString(ret));
    }
}

