/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.pattern.consumer.internals;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.jodah.failsafe.Execution;
import net.openhft.chronicle.core.util.Time;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQRebalanceException;
import org.nuxeo.lib.core.mqueues.mqueues.MQRebalanceListener;
import org.nuxeo.lib.core.mqueues.mqueues.MQRecord;
import org.nuxeo.lib.core.mqueues.mqueues.MQTailer;
import org.nuxeo.lib.core.mqueues.pattern.Message;
import org.nuxeo.lib.core.mqueues.pattern.consumer.BatchPolicy;
import org.nuxeo.lib.core.mqueues.pattern.consumer.Consumer;
import org.nuxeo.lib.core.mqueues.pattern.consumer.ConsumerFactory;
import org.nuxeo.lib.core.mqueues.pattern.consumer.ConsumerPolicy;
import org.nuxeo.lib.core.mqueues.pattern.consumer.ConsumerStatus;
import org.nuxeo.lib.core.mqueues.pattern.consumer.internals.BatchState;

public class ConsumerRunner<M extends Message>
implements Callable<ConsumerStatus>,
MQRebalanceListener {
    private static final Log log = LogFactory.getLog(ConsumerRunner.class);
    public static final String NUXEO_METRICS_REGISTRY_NAME = "org.nuxeo.runtime.metrics.MetricsService";
    protected final ConsumerFactory<M> factory;
    protected final ConsumerPolicy policy;
    protected final MQTailer<M> tailer;
    protected String consumerId;
    protected BatchPolicy currentBatchPolicy;
    protected String threadName;
    protected Consumer<M> consumer;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"org.nuxeo.runtime.metrics.MetricsService");
    protected Timer acceptTimer;
    protected Counter committedCounter;
    protected Timer batchCommitTimer;
    protected Counter batchFailureCount;
    protected Counter consumersCount;
    protected boolean alreadySalted = false;

    public ConsumerRunner(ConsumerFactory<M> factory, ConsumerPolicy policy, MQManager manager, List<MQPartition> defaultAssignments) {
        this.factory = factory;
        this.currentBatchPolicy = policy.getBatchPolicy();
        this.policy = policy;
        this.tailer = this.createTailer(manager, defaultAssignments);
        this.consumerId = this.tailer.toString();
        this.consumersCount = this.newCounter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "queue", "consumers"}));
        this.setTailerPosition(manager);
        log.debug((Object)("Consumer thread created tailing on: " + this.consumerId));
    }

    protected MQTailer<M> createTailer(MQManager manager, List<MQPartition> defaultAssignments) {
        MQTailer tailer;
        if (manager.supportSubscribe()) {
            Set<String> names = defaultAssignments.stream().map(MQPartition::name).collect(Collectors.toSet());
            tailer = manager.subscribe(this.policy.getName(), names, this);
        } else {
            tailer = manager.createTailer(this.policy.getName(), defaultAssignments);
        }
        return tailer;
    }

    protected Counter newCounter(String name) {
        this.registry.remove(name);
        return this.registry.counter(name);
    }

    protected Timer newTimer(String name) {
        this.registry.remove(name);
        return this.registry.timer(name);
    }

    @Override
    public ConsumerStatus call() throws Exception {
        this.threadName = Thread.currentThread().getName();
        this.setMetrics(this.threadName);
        this.consumersCount.inc();
        long start = Time.currentTimeMillis();
        this.consumer = this.factory.createConsumer(this.consumerId);
        try {
            this.consumerLoop();
        }
        finally {
            this.consumer.close();
            this.consumersCount.dec();
            this.tailer.close();
        }
        return new ConsumerStatus(this.consumerId, this.acceptTimer.getCount(), this.committedCounter.getCount(), this.batchCommitTimer.getCount(), this.batchFailureCount.getCount(), start, Time.currentTimeMillis(), false);
    }

    protected void setMetrics(String name) {
        this.acceptTimer = this.newTimer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "queue", "consumer", "accepted", name}));
        this.committedCounter = this.newCounter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "queue", "consumer", "committed", name}));
        this.batchFailureCount = this.newCounter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "queue", "consumer", "batchFailure", name}));
        this.batchCommitTimer = this.newTimer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"importer", "queue", "consumer", "batchCommit", name}));
    }

    protected void addSalt() throws InterruptedException {
        if (this.alreadySalted) {
            return;
        }
        if (this.policy.isSalted()) {
            long randomDelay = ThreadLocalRandom.current().nextLong(this.policy.getBatchPolicy().getTimeThreshold().toMillis());
            Thread.sleep(randomDelay);
        }
        this.alreadySalted = true;
    }

    protected void setTailerPosition(MQManager manager) {
        ConsumerPolicy.StartOffset seekPosition = this.policy.getStartOffset();
        if (manager.supportSubscribe() && seekPosition != ConsumerPolicy.StartOffset.LAST_COMMITTED) {
            throw new UnsupportedOperationException("Tailer startOffset to " + (Object)((Object)seekPosition) + " is not supported in subscribe mode");
        }
        switch (this.policy.getStartOffset()) {
            case BEGIN: {
                this.tailer.toStart();
                break;
            }
            case END: {
                this.tailer.toEnd();
                break;
            }
            default: {
                this.tailer.toLastCommitted();
            }
        }
    }

    protected void consumerLoop() throws InterruptedException {
        boolean end = false;
        while (!end) {
            Execution execution = new Execution(this.policy.getRetryPolicy());
            end = this.processBatchWithRetry(execution);
            if (execution.getLastFailure() == null) continue;
            if (this.policy.continueOnFailure()) {
                log.error((Object)"Skip message on failure after applying the retry policy: ", execution.getLastFailure());
                continue;
            }
            log.error((Object)"Abort on Failure after applying the retry policy: ", execution.getLastFailure());
            end = true;
        }
    }

    protected boolean processBatchWithRetry(Execution execution) throws InterruptedException {
        boolean end = false;
        while (!execution.isComplete()) {
            try {
                end = this.processBatch();
                this.tailer.commit();
                execution.complete();
            }
            catch (Throwable t) {
                this.batchFailureCount.inc();
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    throw t;
                }
                if (t instanceof MQRebalanceException) {
                    log.info((Object)"Rebalance");
                }
                if (execution.canRetryOn(t)) {
                    this.setBatchRetryPolicy();
                    this.tailer.toLastCommitted();
                }
                throw t;
            }
            this.restoreBatchPolicy();
        }
        return end;
    }

    protected void setBatchRetryPolicy() {
        this.currentBatchPolicy = BatchPolicy.NO_BATCH;
    }

    protected void restoreBatchPolicy() {
        this.currentBatchPolicy = this.policy.getBatchPolicy();
    }

    protected boolean processBatch() throws InterruptedException {
        boolean end = false;
        this.beginBatch();
        try {
            BatchState state = this.acceptBatch();
            this.commitBatch(state);
            if (state.getState() == BatchState.State.LAST) {
                log.info((Object)("No more message on tailer: " + this.tailer));
                end = true;
            }
        }
        catch (Exception e) {
            try {
                this.rollbackBatch(e);
            }
            catch (Exception rollbackException) {
                log.error((Object)"Exception on rollback invocation", (Throwable)rollbackException);
            }
            throw e;
        }
        return end;
    }

    protected void beginBatch() {
        this.consumer.begin();
    }

    protected void commitBatch(BatchState state) {
        try (Timer.Context ignore = this.batchCommitTimer.time();){
            this.consumer.commit();
            this.committedCounter.inc((long)state.getSize());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Commit batch size: " + state.getSize() + ", total committed: " + this.committedCounter.getCount()));
            }
        }
    }

    protected void rollbackBatch(Exception e) {
        if (e instanceof MQRebalanceException) {
            log.warn((Object)"Rollback current batch because of consumer rebalancing");
        } else {
            log.warn((Object)"Rollback batch", (Throwable)e);
        }
        this.consumer.rollback();
    }

    protected BatchState acceptBatch() throws InterruptedException {
        MQRecord<M> record;
        BatchState batch = new BatchState(this.currentBatchPolicy);
        batch.start();
        while ((record = this.tailer.read(this.policy.getWaitMessageTimeout())) != null) {
            Message message = (Message)record.message();
            if (message.poisonPill()) {
                log.warn((Object)("Receive a poison pill: " + message));
                batch.last();
            } else {
                try (Timer.Context ignore = this.acceptTimer.time();){
                    this.setThreadName(message);
                    this.consumer.accept(message);
                }
                batch.inc();
                if (message.forceBatch()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Force end of batch: " + message));
                    }
                    batch.force();
                }
            }
            if (batch.getState() == BatchState.State.FILLING) continue;
            return batch;
        }
        batch.last();
        return batch;
    }

    protected void setThreadName(M message) {
        String name = this.threadName + "-" + this.acceptTimer.getCount();
        name = message != null ? name + "-" + message.getId() : name + "-null";
        Thread.currentThread().setName(name);
    }

    @Override
    public void onPartitionsRevoked(Collection<MQPartition> partitions) {
    }

    @Override
    public void onPartitionsAssigned(Collection<MQPartition> partitions) {
        this.consumerId = this.tailer.toString();
    }
}

