/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.pattern.consumer.internals;

import org.nuxeo.lib.core.mqueues.pattern.consumer.BatchPolicy;

public class BatchState {
    protected final BatchPolicy policy;
    protected int counter;
    protected long endMs;
    State state = State.FILLING;

    public BatchState(BatchPolicy policy) {
        this.policy = policy;
    }

    public void start() {
        this.endMs = System.currentTimeMillis() + this.policy.getTimeThreshold().toMillis();
        this.counter = 0;
        this.state = State.FILLING;
    }

    public State inc() {
        if (this.state != State.FILLING) {
            throw new IllegalStateException("Try to add an item to a batch in non filling state:" + (Object)((Object)this.state));
        }
        ++this.counter;
        return this.getState();
    }

    public void force() {
        this.state = State.FULL;
    }

    public void last() {
        this.state = State.LAST;
    }

    public State getState() {
        if (this.state != State.FILLING) {
            return this.state;
        }
        if (this.counter >= this.policy.getCapacity()) {
            this.state = State.FULL;
        } else if (System.currentTimeMillis() > this.endMs) {
            this.state = State.TIMEOUT;
        }
        return this.state;
    }

    public int getSize() {
        return this.counter;
    }

    public static enum State {
        FILLING,
        FULL,
        TIMEOUT,
        LAST;

    }
}

