/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.pattern;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Objects;
import org.nuxeo.lib.core.mqueues.pattern.Message;

public class KeyValueMessage
implements Message {
    static final long serialVersionUID = 20170529L;
    public static final KeyValueMessage POISON_PILL = new KeyValueMessage("_POISON_PILL_", null, true, false);
    protected String key;
    protected byte[] value;
    protected boolean poisonPill = false;
    protected boolean forceBatch = false;

    public KeyValueMessage() {
    }

    protected KeyValueMessage(String key, byte[] value, boolean poisonPill, boolean forceBatch) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
        this.poisonPill = poisonPill;
        this.forceBatch = forceBatch;
    }

    public static KeyValueMessage of(String key, byte[] value) {
        return new KeyValueMessage(key, value, false, false);
    }

    public static KeyValueMessage of(String key) {
        return new KeyValueMessage(key, null, false, false);
    }

    public static KeyValueMessage ofForceBatch(String key, byte[] value) {
        return new KeyValueMessage(key, value, false, true);
    }

    public static KeyValueMessage ofForceBatch(String key) {
        return new KeyValueMessage(key, null, false, true);
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    @Override
    public String getId() {
        return this.key;
    }

    @Override
    public boolean poisonPill() {
        return this.poisonPill;
    }

    @Override
    public boolean forceBatch() {
        return this.forceBatch;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeBoolean(this.poisonPill);
        out.writeBoolean(this.forceBatch);
        if (this.value == null || this.value.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = (String)in.readObject();
        this.poisonPill = in.readBoolean();
        this.forceBatch = in.readBoolean();
        int dataLength = in.readInt();
        if (dataLength == 0) {
            this.value = null;
        } else {
            this.value = new byte[dataLength];
            for (int pos = 0; pos < dataLength; pos += in.read(this.value, pos, dataLength - pos)) {
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueMessage keyValueMessage = (KeyValueMessage)o;
        if (this.poisonPill != keyValueMessage.poisonPill) {
            return false;
        }
        if (this.forceBatch != keyValueMessage.forceBatch) {
            return false;
        }
        return this.key != null ? this.key.equals(keyValueMessage.key) : keyValueMessage.key == null;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        result = 31 * result + (this.poisonPill ? 1 : 0);
        result = 31 * result + (this.forceBatch ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.format("KeyValueMessage(\"%s\", len:%d%s%s)", this.key, this.value != null ? this.value.length : 0, this.poisonPill ? ", poison" : "", this.forceBatch ? ", batch" : "");
    }
}

