/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.mqueues.kafka;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQAppender;
import org.nuxeo.lib.core.mqueues.mqueues.MQLag;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQRebalanceListener;
import org.nuxeo.lib.core.mqueues.mqueues.MQTailer;
import org.nuxeo.lib.core.mqueues.mqueues.internals.AbstractMQManager;
import org.nuxeo.lib.core.mqueues.mqueues.kafka.KafkaMQAppender;
import org.nuxeo.lib.core.mqueues.mqueues.kafka.KafkaMQTailer;
import org.nuxeo.lib.core.mqueues.mqueues.kafka.KafkaUtils;

public class KafkaMQManager
extends AbstractMQManager {
    public static final String DISABLE_SUBSCRIBE_PROP = "subscribe.disable";
    public static final String DEFAULT_REPLICATION_FACTOR_PROP = "default.replication.factor";
    protected final KafkaUtils kUtils;
    protected final Properties producerProperties;
    protected final Properties consumerProperties;
    protected final Properties adminProperties;
    protected final String prefix;
    protected final short defaultReplicationFactor;
    protected boolean disableSubscribe = false;

    public KafkaMQManager(String zkServers, Properties producerProperties, Properties consumerProperties) {
        this(zkServers, null, producerProperties, consumerProperties);
    }

    public KafkaMQManager(String zkServers, String topicPrefix, Properties producerProperties, Properties consumerProperties) {
        this.prefix = topicPrefix != null ? topicPrefix : "";
        this.kUtils = new KafkaUtils(zkServers);
        this.disableSubscribe = Boolean.valueOf(consumerProperties.getProperty(DISABLE_SUBSCRIBE_PROP, "false"));
        this.defaultReplicationFactor = Short.parseShort(producerProperties.getProperty(DEFAULT_REPLICATION_FACTOR_PROP, "1"));
        this.producerProperties = this.normalizeProducerProperties(producerProperties);
        this.consumerProperties = KafkaMQManager.normalizeConsumerProperties(consumerProperties);
        this.adminProperties = this.createAdminProperties(producerProperties, consumerProperties);
    }

    protected String getTopicName(String name) {
        return this.prefix + name;
    }

    protected String getNameFromTopic(String topic) {
        if (!topic.startsWith(this.prefix)) {
            throw new IllegalArgumentException(String.format("topic %s with invalid prefix %s", topic, this.prefix));
        }
        return topic.replaceFirst(this.prefix, "");
    }

    @Override
    public void create(String name, int size) {
        this.kUtils.createTopic(this.getAdminProperties(), this.getTopicName(name), size, this.defaultReplicationFactor);
    }

    @Override
    public boolean exists(String name) {
        return this.kUtils.topicExists(this.getTopicName(name));
    }

    @Override
    public <M extends Externalizable> MQAppender<M> createAppender(String name) {
        return KafkaMQAppender.open(this.getTopicName(name), name, this.producerProperties, this.consumerProperties);
    }

    @Override
    protected <M extends Externalizable> MQTailer<M> acquireTailer(Collection<MQPartition> partitions, String group) {
        partitions.forEach(this::checkValidPartition);
        return KafkaMQTailer.createAndAssign(this.prefix, partitions, group, (Properties)this.consumerProperties.clone());
    }

    protected void checkValidPartition(MQPartition partition) {
        int partitions = this.kUtils.getNumberOfPartitions(this.getAdminProperties(), this.getTopicName(partition.name()));
        if (partition.partition() >= partitions) {
            throw new IllegalArgumentException("Partition out of bound " + partition + " max: " + partitions);
        }
    }

    public Properties getProducerProperties() {
        return this.producerProperties;
    }

    public Properties getConsumerProperties() {
        return this.consumerProperties;
    }

    public Properties getAdminProperties() {
        return this.adminProperties;
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.kUtils != null) {
            this.kUtils.close();
        }
    }

    @Override
    public boolean supportSubscribe() {
        return !this.disableSubscribe;
    }

    @Override
    protected <M extends Externalizable> MQTailer<M> doSubscribe(String group, Collection<String> names, MQRebalanceListener listener) {
        return KafkaMQTailer.createAndSubscribe(this.prefix, names, group, (Properties)this.consumerProperties.clone(), listener);
    }

    protected static Properties normalizeConsumerProperties(Properties consumerProperties) {
        Properties ret = consumerProperties != null ? (Properties)consumerProperties.clone() : new Properties();
        ret.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        ret.put("value.deserializer", "org.apache.kafka.common.serialization.BytesDeserializer");
        ret.put("enable.auto.commit", (Object)false);
        ret.put("auto.offset.reset", "earliest");
        ret.remove(DISABLE_SUBSCRIBE_PROP);
        return ret;
    }

    protected Properties normalizeProducerProperties(Properties producerProperties) {
        Properties ret = producerProperties != null ? (Properties)producerProperties.clone() : new Properties();
        ret.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        ret.put("value.serializer", "org.apache.kafka.common.serialization.BytesSerializer");
        ret.remove(DEFAULT_REPLICATION_FACTOR_PROP);
        return ret;
    }

    protected Properties createAdminProperties(Properties producerProperties, Properties consumerProperties) {
        Properties ret = new Properties();
        ret.put("bootstrap.servers", producerProperties.getOrDefault((Object)"bootstrap.servers", consumerProperties.get("bootstrap.servers")));
        return ret;
    }

    @Override
    public List<MQLag> getLagPerPartition(String name, String group) {
        MQLag[] ret;
        Properties props = (Properties)this.consumerProperties.clone();
        props.put("group.id", group);
        try (KafkaConsumer consumer = new KafkaConsumer(props);){
            ArrayList topicPartitions = new ArrayList();
            consumer.partitionsFor(this.getTopicName(name)).forEach(meta -> topicPartitions.add(new TopicPartition(meta.topic(), meta.partition())));
            ret = new MQLag[topicPartitions.size()];
            Map endOffsets = consumer.endOffsets(topicPartitions);
            for (TopicPartition topicPartition : topicPartitions) {
                Long endOffset;
                long committedOffset = 0L;
                OffsetAndMetadata committed = consumer.committed(topicPartition);
                if (committed != null) {
                    committedOffset = committed.offset();
                }
                if ((endOffset = (Long)endOffsets.get(topicPartition)) == null) {
                    endOffset = 0L;
                }
                ret[topicPartition.partition()] = new MQLag(committedOffset, endOffset);
            }
        }
        return Arrays.asList(ret);
    }

    @Override
    public List<String> listAll() {
        return this.kUtils.listTopics().stream().filter(name -> name.startsWith(this.prefix)).map(this::getNameFromTopic).collect(Collectors.toList());
    }

    public String toString() {
        return "KafkaMQManager{producerProperties=" + this.producerProperties + ", consumerProperties=" + this.consumerProperties + ", prefix='" + this.prefix + '\'' + '}';
    }

    @Override
    public List<String> listConsumerGroups(String name) {
        String topic = this.getTopicName(name);
        if (!this.exists(name)) {
            throw new IllegalArgumentException("Unknown MQueue: " + name);
        }
        return this.kUtils.listConsumers(this.getProducerProperties(), topic);
    }
}

