/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.mqueues.internals;

import java.io.Externalizable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.lib.core.mqueues.mqueues.MQAppender;
import org.nuxeo.lib.core.mqueues.mqueues.MQManager;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQRebalanceListener;
import org.nuxeo.lib.core.mqueues.mqueues.MQTailer;
import org.nuxeo.lib.core.mqueues.mqueues.internals.MQPartitionGroup;

public abstract class AbstractMQManager
implements MQManager {
    protected final Map<String, MQAppender> appenders = new ConcurrentHashMap<String, MQAppender>();
    protected final Map<MQPartitionGroup, MQTailer> tailersAssignments = new ConcurrentHashMap<MQPartitionGroup, MQTailer>();
    protected final Set<MQTailer> tailers = Collections.newSetFromMap(new ConcurrentHashMap());

    protected abstract void create(String var1, int var2);

    protected abstract <M extends Externalizable> MQAppender<M> createAppender(String var1);

    protected abstract <M extends Externalizable> MQTailer<M> acquireTailer(Collection<MQPartition> var1, String var2);

    protected abstract <M extends Externalizable> MQTailer<M> doSubscribe(String var1, Collection<String> var2, MQRebalanceListener var3);

    @Override
    public synchronized boolean createIfNotExists(String name, int size) {
        if (!this.exists(name)) {
            this.create(name, size);
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(String name) {
        return false;
    }

    @Override
    public <M extends Externalizable> MQTailer<M> createTailer(String group, Collection<MQPartition> partitions) {
        partitions.forEach(partition -> this.checkTailerForPartition(group, (MQPartition)partition));
        MQTailer ret = this.acquireTailer(partitions, group);
        partitions.forEach(partition -> this.tailersAssignments.put(new MQPartitionGroup(group, (MQPartition)partition), ret));
        this.tailers.add(ret);
        return ret;
    }

    @Override
    public boolean supportSubscribe() {
        return false;
    }

    @Override
    public <M extends Externalizable> MQTailer<M> subscribe(String group, Collection<String> names, MQRebalanceListener listener) {
        MQTailer<M> ret = this.doSubscribe(group, names, listener);
        this.tailers.add(ret);
        return ret;
    }

    protected void checkTailerForPartition(String group, MQPartition partition) {
        MQPartitionGroup key = new MQPartitionGroup(group, partition);
        MQTailer ret = this.tailersAssignments.get(key);
        if (ret != null && !ret.closed()) {
            throw new IllegalArgumentException("Tailer for this partition already created: " + partition + ", group: " + group);
        }
        if (!this.exists(partition.name())) {
            throw new IllegalArgumentException("Tailer with unknown MQueue name: " + partition.name());
        }
    }

    @Override
    public <M extends Externalizable> MQTailer<M> createTailer(String group, MQPartition partition) {
        return this.createTailer(group, Collections.singletonList(partition));
    }

    @Override
    public synchronized <M extends Externalizable> MQAppender<M> getAppender(String name) {
        if (!this.appenders.containsKey(name) || this.appenders.get(name).closed()) {
            if (this.exists(name)) {
                MQAppender<M> appender = this.createAppender(name);
                this.appenders.put(name, appender);
            } else {
                throw new IllegalArgumentException("unknown MQueue name: " + name);
            }
        }
        return this.appenders.get(name);
    }

    @Override
    public void close() throws Exception {
        for (MQAppender app : this.appenders.values()) {
            app.close();
        }
        this.appenders.clear();
        for (MQTailer tailer : this.tailers) {
            tailer.close();
        }
        this.tailers.clear();
        this.tailersAssignments.clear();
    }
}

