/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.core.mqueues.mqueues;

import java.io.Externalizable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.nuxeo.lib.core.mqueues.mqueues.MQAppender;
import org.nuxeo.lib.core.mqueues.mqueues.MQLag;
import org.nuxeo.lib.core.mqueues.mqueues.MQPartition;
import org.nuxeo.lib.core.mqueues.mqueues.MQRebalanceListener;
import org.nuxeo.lib.core.mqueues.mqueues.MQTailer;

public interface MQManager
extends AutoCloseable {
    public boolean exists(String var1);

    public boolean createIfNotExists(String var1, int var2);

    public boolean delete(String var1);

    public <M extends Externalizable> MQAppender<M> getAppender(String var1);

    public <M extends Externalizable> MQTailer<M> createTailer(String var1, MQPartition var2);

    public <M extends Externalizable> MQTailer<M> createTailer(String var1, Collection<MQPartition> var2);

    default public <M extends Externalizable> MQTailer<M> createTailer(String group, String name) {
        int size = this.getAppender(name).size();
        return this.createTailer(group, IntStream.range(0, size).boxed().map(partition -> new MQPartition(name, (int)partition)).collect(Collectors.toList()));
    }

    public boolean supportSubscribe();

    public <M extends Externalizable> MQTailer<M> subscribe(String var1, Collection<String> var2, MQRebalanceListener var3);

    public List<MQLag> getLagPerPartition(String var1, String var2);

    default public MQLag getLag(String name, String group) {
        long[] end = new long[]{0L};
        long[] pos = new long[]{Long.MAX_VALUE};
        long[] lag = new long[]{0L};
        long[] endMessages = new long[]{0L};
        this.getLagPerPartition(name, group).forEach(item -> {
            if (item.lowerOffset() > 0L) {
                pos[0] = Math.min(pos[0], item.lowerOffset());
            }
            end[0] = Math.max(end[0], item.upperOffset());
            endMessages[0] = endMessages[0] + item.upper();
            lag[0] = lag[0] + item.lag();
        });
        return new MQLag(pos[0], end[0], lag[0], endMessages[0]);
    }

    public List<String> listAll();

    public List<String> listConsumerGroups(String var1);
}

