/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.producer;

import java.nio.file.Path;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.DocumentMessage;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.ProducerIterator;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.RandomDocumentMessageProducer;

public class RandomDocumentMessageProducerFactory
implements ProducerFactory<DocumentMessage> {
    private final long nbDocuments;
    private final String lang;
    private final Path blobInfoDirectory;
    private final int blobSizeKb;

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, int blobSizeKb) {
        this.nbDocuments = nbDocuments;
        this.lang = lang;
        this.blobInfoDirectory = null;
        this.blobSizeKb = blobSizeKb;
    }

    public RandomDocumentMessageProducerFactory(long nbDocuments, String lang, Path blobInfoDirectory) {
        this.nbDocuments = nbDocuments;
        this.lang = lang;
        this.blobInfoDirectory = blobInfoDirectory;
        this.blobSizeKb = 0;
    }

    public ProducerIterator<DocumentMessage> createProducer(int producerId) {
        return new RandomDocumentMessageProducer(producerId, this.nbDocuments, this.lang, this.blobInfoDirectory).withBlob(this.blobSizeKb, false);
    }
}

