/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.producer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.DocumentMessage;

public class RandomBlobInfoProvider
implements AutoCloseable {
    private final Path basePath;
    private final List<Path> fileList;
    private File currentFile;
    private int currentFileIndex;
    private BufferedReader currentReader;
    private FileReader currentFileReader;

    public RandomBlobInfoProvider(Path blobInfoDirectory, int seed) {
        this.basePath = blobInfoDirectory;
        this.currentFileIndex = seed;
        this.fileList = this.listBlobInfoFiles();
        this.getNextBufferedReader();
    }

    private List<Path> listBlobInfoFiles() {
        List<Path> ret;
        try (Stream<Path> paths = Files.walk(this.basePath, new FileVisitOption[0]);){
            ret = paths.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith("csv")).collect(Collectors.toList());
            ret.sort(Comparator.comparing(Path::getFileName));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid blobInfo directory: " + this.basePath, e);
        }
        if (ret.isEmpty()) {
            throw new IllegalArgumentException("Invalid blobInfo directory no csv file found: " + this.basePath);
        }
        return ret;
    }

    public BlobInfo getBlobInfo(DocumentMessage.Builder builder) {
        String line = this.getNextLine();
        String[] tokens = line.split(",");
        if (tokens.length < 6) {
            throw new IllegalArgumentException("Invalid csv file not enough field per line: " + this.currentFile + " " + line);
        }
        BlobInfo ret = new BlobInfo();
        ret.key = tokens[0].trim();
        ret.digest = tokens[1].trim();
        ret.length = Long.valueOf(tokens[2].trim());
        ret.filename = tokens[3].trim().replace("\"", "");
        ret.mimeType = tokens[4].trim();
        ret.encoding = tokens[5].trim();
        return ret;
    }

    private void getNextBufferedReader() {
        this.currentFile = this.fileList.get(this.currentFileIndex % this.fileList.size()).toFile();
        ++this.currentFileIndex;
        try {
            this.currentFileReader = new FileReader(this.currentFile);
            this.currentReader = new BufferedReader(new FileReader(this.currentFile));
            this.currentReader.readLine();
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Invalid file: " + this.currentFile, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read file: " + this.currentFile, e);
        }
    }

    private String getNextLine() {
        String ret;
        try {
            ret = this.currentReader.readLine();
            if (ret == null) {
                this.currentReader.close();
                this.currentFileReader.close();
                this.getNextBufferedReader();
                return this.getNextLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not read file: " + this.currentFile, e);
        }
        return ret;
    }

    @Override
    public void close() throws Exception {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
        if (this.currentFileReader != null) {
            this.currentFileReader.close();
        }
    }
}

