/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.AbstractConsumer;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.BlobMessage;
import org.nuxeo.runtime.api.Framework;

public class BlobMessageConsumer
extends AbstractConsumer<BlobMessage> {
    private static final AtomicInteger consumerCounter = new AtomicInteger(0);
    private final Integer id = consumerCounter.getAndIncrement();
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String HEADER = "key, digest, length, filename, mimetype, encoding\n";
    private final BlobProvider blobProvider;
    private final PrintWriter outputWriter;
    private final FileWriter outputFileWriter;
    private final String blobProviderName;

    public BlobMessageConsumer(String consumerId, String blobProviderName, Path outputBlobInfoDirectory) {
        super(consumerId);
        this.blobProviderName = blobProviderName;
        this.blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blobProviderName);
        if (this.blobProvider == null) {
            throw new IllegalArgumentException("Invalid blob provider: " + blobProviderName);
        }
        Path outputFile = Paths.get(outputBlobInfoDirectory.toString(), String.format("bi-%02d.csv", this.id));
        try {
            outputBlobInfoDirectory.toFile().mkdirs();
            this.outputFileWriter = new FileWriter(outputFile.toFile(), true);
            BufferedWriter bw = new BufferedWriter(this.outputFileWriter);
            this.outputWriter = new PrintWriter(bw);
            this.outputWriter.write(HEADER);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid output path: " + outputFile, e);
        }
    }

    public void close() throws Exception {
        this.outputWriter.close();
        this.outputFileWriter.close();
    }

    public void begin() {
    }

    public void accept(BlobMessage message) {
        try {
            Object blob = message.getPath() != null ? new FileBlob(new File(message.getPath())) : new StringBlob(message.getContent(), null, null, null);
            BlobInfo bi = new BlobInfo();
            bi.digest = this.blobProvider.writeBlob((Blob)blob);
            bi.key = this.blobProviderName + ":" + bi.digest;
            bi.length = blob.getLength();
            bi.filename = message.getFilename();
            bi.mimeType = message.getMimetype();
            bi.encoding = message.getEncoding();
            this.saveBlobInfo(bi);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid blob: " + message, e);
        }
    }

    private void saveBlobInfo(BlobInfo bi) {
        this.outputWriter.write(String.format("%s, %s, %d, \"%s\", %s, %s\n", bi.key, bi.digest, bi.length, this.sanitize(bi.filename), this.sanitize(bi.mimeType), this.sanitize(bi.encoding)));
    }

    private String sanitize(String str) {
        if (str == null || str.trim().isEmpty()) {
            return "";
        }
        return str;
    }

    public void commit() {
        this.outputWriter.flush();
    }

    public void rollback() {
    }
}

