/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.automation;

import java.nio.file.Paths;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.platform.importer.mqueues.automation.RandomBlobProducers;
import org.nuxeo.ecm.platform.importer.mqueues.chronicle.ChronicleConfig;
import org.nuxeo.ecm.platform.importer.mqueues.kafka.KafkaConfigService;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQManager;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.chronicle.ChronicleMQManager;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.kafka.KafkaMQManager;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.DocumentMessage;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.ProducerFactory;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.ProducerPool;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.producer.RandomDocumentMessageProducerFactory;
import org.nuxeo.runtime.api.Framework;

@Operation(id="MQImporter.runRandomDocumentProducers", category="Services", label="Produces random blobs", since="9.1", description="Produces random blobs in a mqueues.")
public class RandomDocumentProducers {
    private static final Log log = LogFactory.getLog(RandomDocumentProducers.class);
    public static final String ID = "MQImporter.runRandomDocumentProducers";
    public static final String DEFAULT_MQ_NAME = "mq-doc";
    @Context
    protected OperationContext ctx;
    @Param(name="nbDocuments")
    protected Integer nbDocuments;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads = 8;
    @Param(name="avgBlobSizeKB", required=false)
    protected Integer avgBlobSizeKB = 1;
    @Param(name="lang", required=false)
    protected String lang = "en_US";
    @Param(name="mqName", required=false)
    protected String mqName;
    @Param(name="mqSize", required=false)
    protected Integer mqSize;
    @Param(name="blobInfoPath", required=false)
    protected String blobInfoPath;
    @Param(name="kafkaConfig", required=false)
    protected String kafkaConfig;

    @OperationMethod
    public void run() {
        RandomBlobProducers.checkAccess(this.ctx);
        try (MQManager<DocumentMessage> manager = this.getManager();){
            manager.createIfNotExists(this.getMQName(), this.getMQSize());
            ProducerPool producers = this.blobInfoPath != null ? new ProducerPool(this.getMQName(), manager, (ProducerFactory)new RandomDocumentMessageProducerFactory((long)this.nbDocuments.intValue(), this.lang, Paths.get(this.blobInfoPath, new String[0])), this.nbThreads.shortValue()) : new ProducerPool(this.getMQName(), manager, (ProducerFactory)new RandomDocumentMessageProducerFactory((long)this.nbDocuments.intValue(), this.lang, this.avgBlobSizeKB), this.nbThreads.shortValue());
            producers.start().get();
            producers.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected int getMQSize() {
        if (this.mqSize != null && this.mqSize > 0) {
            return this.mqSize;
        }
        return this.nbThreads;
    }

    protected String getMQName() {
        if (this.mqName != null) {
            return this.mqName;
        }
        return DEFAULT_MQ_NAME;
    }

    protected MQManager<DocumentMessage> getManager() {
        if (this.kafkaConfig == null || this.kafkaConfig.isEmpty()) {
            return new ChronicleMQManager(ChronicleConfig.getBasePath("import"), ChronicleConfig.getRetentionDuration());
        }
        KafkaConfigService service = (KafkaConfigService)Framework.getService(KafkaConfigService.class);
        return new KafkaMQManager(service.getZkServers(this.kafkaConfig), service.getTopicPrefix(this.kafkaConfig), service.getProducerProperties(this.kafkaConfig), service.getConsumerProperties(this.kafkaConfig));
    }
}

