/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.automation;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.platform.importer.mqueues.automation.RandomBlobProducers;
import org.nuxeo.ecm.platform.importer.mqueues.chronicle.ChronicleConfig;
import org.nuxeo.ecm.platform.importer.mqueues.kafka.KafkaConfigService;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.MQManager;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.chronicle.ChronicleMQManager;
import org.nuxeo.ecm.platform.importer.mqueues.mqueues.kafka.KafkaMQManager;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.BatchPolicy;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.BlobMessageConsumerFactory;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.ConsumerFactory;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.ConsumerPolicy;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.consumer.ConsumerPool;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.message.BlobMessage;
import org.nuxeo.runtime.api.Framework;

@Operation(id="MQImporter.runBlobConsumers", category="Services", label="Import blobs", since="9.1", description="Import mqueues blob into the binarystore.")
public class BlobConsumers {
    private static final Log log = LogFactory.getLog(BlobConsumers.class);
    public static final String ID = "MQImporter.runBlobConsumers";
    @Context
    protected OperationContext ctx;
    @Param(name="nbThreads", required=false)
    protected Integer nbThreads;
    @Param(name="blobInfoPath")
    protected String blobInfoPath;
    @Param(name="blobProviderName", required=false)
    protected String blobProviderName = "default";
    @Param(name="batchSize", required=false)
    protected Integer batchSize = 10;
    @Param(name="batchThresholdS", required=false)
    protected Integer batchThresholdS = 20;
    @Param(name="retryMax", required=false)
    protected Integer retryMax = 3;
    @Param(name="retryDelayS", required=false)
    protected Integer retryDelayS = 2;
    @Param(name="mqName", required=false)
    protected String mqName;
    @Param(name="kafkaConfig", required=false)
    protected String kafkaConfig;

    @OperationMethod
    public void run() {
        RandomBlobProducers.checkAccess(this.ctx);
        ConsumerPolicy consumerPolicy = ConsumerPolicy.builder().name(ID).batchPolicy(BatchPolicy.builder().capacity(this.batchSize.intValue()).timeThreshold(Duration.ofSeconds(this.batchThresholdS.intValue())).build()).retryPolicy(new RetryPolicy().withMaxRetries(this.retryMax.intValue()).withDelay((long)this.retryDelayS.intValue(), TimeUnit.SECONDS)).maxThreads(this.getNbThreads()).build();
        try (MQManager<BlobMessage> manager = this.getManager();
             ConsumerPool consumers = new ConsumerPool(this.getMQName(), manager, (ConsumerFactory)new BlobMessageConsumerFactory(this.blobProviderName, Paths.get(this.blobInfoPath, new String[0])), consumerPolicy);){
            consumers.start().get();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected short getNbThreads() {
        if (this.nbThreads != null) {
            return this.nbThreads.shortValue();
        }
        return 0;
    }

    protected String getMQName() {
        if (this.mqName != null) {
            return this.mqName;
        }
        return "mq-blob";
    }

    protected MQManager<BlobMessage> getManager() {
        if (this.kafkaConfig == null || this.kafkaConfig.isEmpty()) {
            return new ChronicleMQManager(ChronicleConfig.getBasePath("import"), ChronicleConfig.getRetentionDuration());
        }
        KafkaConfigService service = (KafkaConfigService)Framework.getService(KafkaConfigService.class);
        return new KafkaMQManager(service.getZkServers(this.kafkaConfig), service.getTopicPrefix(this.kafkaConfig), service.getProducerProperties(this.kafkaConfig), service.getConsumerProperties(this.kafkaConfig));
    }
}

