/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.mqueues.pattern;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Objects;
import org.nuxeo.ecm.platform.importer.mqueues.pattern.Message;

public class keyValueMessage
implements Message {
    static final long serialVersionUID = 20170529L;
    public static final keyValueMessage POISON_PILL = new keyValueMessage("_POISON_PILL_", null, true, false);
    private String key;
    private byte[] value;
    private boolean poisonPill = false;
    private boolean forceBatch = false;

    public keyValueMessage() {
    }

    protected keyValueMessage(String key, byte[] value, boolean poisonPill, boolean forceBatch) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
        this.poisonPill = poisonPill;
        this.forceBatch = forceBatch;
    }

    public static keyValueMessage of(String key, byte[] value) {
        return new keyValueMessage(key, value, false, false);
    }

    public static keyValueMessage of(String key) {
        return new keyValueMessage(key, null, false, false);
    }

    public static keyValueMessage ofForceBatch(String key, byte[] value) {
        return new keyValueMessage(key, value, false, true);
    }

    public static keyValueMessage ofForceBatch(String key) {
        return new keyValueMessage(key, null, false, true);
    }

    public String key() {
        return this.key;
    }

    public byte[] value() {
        return this.value;
    }

    @Override
    public String getId() {
        return this.key;
    }

    @Override
    public boolean poisonPill() {
        return this.poisonPill;
    }

    @Override
    public boolean forceBatch() {
        return this.forceBatch;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeBoolean(this.poisonPill);
        out.writeBoolean(this.forceBatch);
        if (this.value == null || this.value.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.value.length);
            out.write(this.value);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = (String)in.readObject();
        this.poisonPill = in.readBoolean();
        this.forceBatch = in.readBoolean();
        int dataLength = in.readInt();
        if (dataLength == 0) {
            this.value = null;
        } else {
            this.value = new byte[dataLength];
            for (int pos = 0; pos < dataLength; pos += in.read(this.value, pos, dataLength - pos)) {
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        keyValueMessage keyValueMessage2 = (keyValueMessage)o;
        if (this.poisonPill != keyValueMessage2.poisonPill) {
            return false;
        }
        if (this.forceBatch != keyValueMessage2.forceBatch) {
            return false;
        }
        return this.key != null ? this.key.equals(keyValueMessage2.key) : keyValueMessage2.key == null;
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + Arrays.hashCode(this.value);
        result = 31 * result + (this.poisonPill ? 1 : 0);
        result = 31 * result + (this.forceBatch ? 1 : 0);
        return result;
    }

    public String toString() {
        return String.format("keyValueMessage(\"%s\", len:%d%s%s)", this.key, this.value != null ? this.value.length : 0, this.poisonPill ? ", poison" : "", this.forceBatch ? ", batch" : "");
    }
}

